<?xml version="1.0"?> <!-- -*- xml -*- -->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:exsl="http://exslt.org/common"
  extension-element-prefixes="exsl">

  <xsl:template match="/guikachu-doc">
<!--    <xsl:variable name="uri"><xsl:apply-templates select="section[1]" mode="uri"/></xsl:variable>-->
    <xsl:variable name="uri">index.html</xsl:variable>
    <xsl:message>
      <xsl:text>Creating '</xsl:text>
      <xsl:value-of select="$uri"/>
      <xsl:text>'</xsl:text>
    </xsl:message>
    
    <exsl:document href="{$uri}"
      method="html" encoding="iso-8859-1"
      indent="yes">
      <html>
	<head>
	  <title><xsl:value-of select="title/text()"/></title>
	  <xsl:apply-templates select="section[1]" mode="header"/>
	</head>
	<body>

	  <xsl:apply-templates select="title"/>

	  <div id="toc">
	    <a name="toc"/>
	    <h1><xsl:text>Table of Contents</xsl:text></h1>
	    <dl>
	      <xsl:apply-templates select="section" mode="toc"/>
	    </dl>
	  </div>
	  
	  <xsl:apply-templates select="section"/>
	  
	</body>
      </html>
    </exsl:document>
  </xsl:template>

  <xsl:template match="section" mode="header">
    <!-- CSS -->
    <link rel="stylesheet" type="text/css" href="guikachu-doc-html.css"/>

    <!-- TOC -->
    <link rel="toc" href="index.html#toc"/>

    <!-- Prev -->
    <xsl:if test="preceding-sibling::section">
      <xsl:variable name="prev" select="preceding-sibling::section[1]"/>
      <xsl:variable name="prev-uri">
	<xsl:apply-templates select="$prev" mode="uri"/>
      </xsl:variable>
      <link rel="prev" href="{$prev-uri}" title="Previous: {$prev/title/text()}"/>
    </xsl:if>
    
    <!-- Next -->
    <xsl:if test="following-sibling::section">
      <xsl:variable name="next" select="following-sibling::section[1]"/>
      <xsl:variable name="next-uri">
	<xsl:apply-templates select="$next" mode="uri"/>
      </xsl:variable>
      <link rel="next" href="{$next-uri}" title="Next: {$next/title/text()}"/>
    </xsl:if>	  

  </xsl:template>  
  
  <xsl:template match="section/title">
    <h1 id="section-title">
      <xsl:apply-templates/>
    </h1>
  </xsl:template>

  <xsl:template match="guikachu-doc/title">
    <h1 id="doc-title">
      <xsl:apply-templates/>
    </h1>
  </xsl:template>

  <xsl:template match="section" mode="page-contents">	
   <a name="sec-{@id}"/>
    <xsl:apply-templates select="title"/>

    <xsl:if test="para">
      <xsl:apply-templates select="para"/>
    </xsl:if>

    <xsl:if test="resource">
      <xsl:apply-templates select="resource"/>
    </xsl:if>
    
    <hr/>	  

    <table width="100%" align="center" border="0" id="navbar">
      <tr>

	<!-- Link to previous section -->
	<td width="33%" align="right" valign="top">
	  <xsl:variable name="prev" select="preceding-sibling::section[1]"/>
	  <xsl:if test="$prev">
	    <xsl:variable name="prev-uri">
	      <xsl:apply-templates select="$prev" mode="uri"/>
	    </xsl:variable>
	    
	    <a href="{$prev-uri}">
	      <xsl:text>Previous: </xsl:text>
	      <xsl:value-of select="$prev/title/text()"/>
	    </a>
	  </xsl:if>
	</td>

	<td width="33%" align="center" valign="top">
	  <a href="index.html#toc"><xsl:text>Index</xsl:text></a>
	</td>
	
	<!-- Link to next section -->
	<td width="33%" align="left" valign="top">
	  <xsl:variable name="next" select="following-sibling::section[1]"/>
	  <xsl:if test="$next">	
	    <xsl:variable name="next-uri">
	      <xsl:apply-templates select="$next" mode="uri"/>
	    </xsl:variable>

	    <a href="{$next-uri}">
	      <xsl:text>Next: </xsl:text>
	      <xsl:value-of select="$next/title/text()"/>
	    </a>
	  </xsl:if>
	</td>
      </tr>
    </table>
    
  </xsl:template>

  <xsl:template match="section" mode="uri"> <!-- section[1] -->
    <xsl:text>index.html#sec-</xsl:text>
    <xsl:value-of select="@id"/>
  </xsl:template>
  
  <xsl:template match="section[preceding-sibling::section]" mode="uri"> <!-- section[n] -->
    <xsl:value-of select="@id"/>
    <xsl:text>.html</xsl:text>    
  </xsl:template>

  <xsl:template match="section" mode="separate-file">

    <xsl:variable name="uri"><xsl:apply-templates select="." mode="uri"/></xsl:variable>

    <xsl:message>
      <xsl:text>Creating '</xsl:text>
      <xsl:value-of select="$uri"/>
      <xsl:text>'</xsl:text>
    </xsl:message>

    <exsl:document href="{$uri}"
      method="html" encoding="iso-8859-1"
      indent="yes">
      <html>
	<head>
	  <title><xsl:value-of select="title/text()"/></title>
	  <xsl:apply-templates select="." mode="header"/>
	</head>    
	<body>	  	  
	  <xsl:apply-templates select="." mode="page-contents"/>
	</body>
      </html>
    </exsl:document>
  </xsl:template>

  <xsl:template match="/guikachu-doc/section">
    <xsl:apply-templates select="." mode="separate-file"/>
  </xsl:template>

  <xsl:template match="/guikachu-doc/section[1]">
    <xsl:apply-templates select="." mode="page-contents"/>
  </xsl:template>
  
  <xsl:include href="toc.xsl"/>
  <xsl:include href="inline.xsl"/>
  <xsl:include href="property.xsl"/>
  <xsl:include href="resource.xsl"/>
  
</xsl:stylesheet>
