//$Id: propertytable.cc,v 1.12 2001/11/10 15:13:00 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "propertytable.h"

#include <gtk--/separator.h>
#include <gtk--/label.h>
#include <gtk--/eventbox.h>
#include <gtk--/tooltips.h>
#include <gtk--/alignment.h>
#include <gtk--/window.h>
#include <gtk--/togglebutton.h>
#include <gtk/gtknotebook.h>

using namespace Guikachu::GUI;

PropertyTable::PropertyTable ():
    accel_group (Gtk::AccelGroup::create ()),
    curr_row (0)
{
    set_border_width (5);
    set_row_spacings (5);
    set_col_spacings (5);

    parent_changed.connect (SigC::slot (this, &PropertyTable::parent_changed_cb));
    map_.connect (SigC::slot (this, &PropertyTable::map_cb));
}

PropertyTable::~PropertyTable ()
{
    accel_group->unref ();
}

Gtk::Widget *PropertyTable::create_label (const std::string &label,
					  Gtk::Widget       &control,
					  const std::string &tooltip)
{
    Gtk::Widget  *ret_val;
    Gtk::Label   *label_widget = new Gtk::Label (label, 1, 0.5);
    gint          accel_key;

    accel_key = label_widget->parse_uline (label);

    if (accel_group)
    {
	/* FIXME: These specialization hacks are ugly. */
	
	Gtk::ToggleButton *togglebutton = dynamic_cast<Gtk::ToggleButton*> (&control);
	if (togglebutton)
	    togglebutton->add_accelerator ("clicked",
					   *accel_group, accel_key,
					   GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);
	else
	    control.add_accelerator ("grab_focus",
				     *accel_group, accel_key,
				     GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);
    }
    
    if (tooltip != "")
    {
	Gtk::EventBox *e_box = new Gtk::EventBox;
	e_box->add (*manage (label_widget));
	
	Gtk::Tooltips *tips = new Gtk::Tooltips;
	tips->set_tip (*e_box, tooltip);
	manage (tips);

	ret_val = e_box;
    } else {
	ret_val = label_widget;
    }
    
    ret_val->show_all ();

    return ret_val;
}

    
void PropertyTable::add (const std::string &label,
			 Gtk::Widget       &control,
			 const std::string &tooltip = "")
{
    
    Gtk::Text *text;
    if ((text = dynamic_cast<Gtk::Text*>(&control)))
    {
	/* Yes, we are being a wise-ass here. But it works for the
	   moment:) */
	   
	add (label, *text, tooltip);
	return;
    }

    Gtk::Widget *label_widget = create_label (label, control, tooltip);
    control.show ();
    
    attach (*manage (label_widget),
	    0, 1,
	    curr_row, curr_row + 1,
	    GTK_FILL,
	    GTK_FILL);
    attach (control,
	    1, 2,
	    curr_row, curr_row + 1,
	    GTK_FILL | GTK_EXPAND,
	    GTK_FILL);

    curr_row++;
}

void PropertyTable::add (const std::string  &label,
			 Gtk::Text          &control,
			 const std::string  &tooltip = "")
{
    Gtk::Widget *label_widget = create_label (label, control, tooltip);
    Gtk::Alignment *alignment = new Gtk::Alignment (0.5, 0, 1, 0);
    alignment->add (*manage (label_widget));
    
    control.show ();
    
    attach (*manage (alignment),
	    0, 1,
	    curr_row, curr_row + 1,
	    GTK_FILL | GTK_EXPAND,
	    GTK_FILL);
    
    attach (control,
	    1, 2,
	    curr_row, curr_row + 1,
	    GTK_FILL | GTK_EXPAND,
	    GTK_FILL | GTK_EXPAND);

    curr_row++;
}

void PropertyTable::add_separator ()
{
    Gtk::HSeparator *separator = new Gtk::HSeparator ();

    separator->show ();

    attach (*manage (separator),
	    0, 2,
	    curr_row, curr_row + 1,
	    GTK_FILL, GTK_FILL);

    curr_row++;
}

void PropertyTable::parent_changed_cb (Gtk::Widget *old_parent)
{
    if (old_parent)
    {
	Gtk::Widget *old_toplevel = Gtk::wrap (
	    gtk_widget_get_toplevel (old_parent->gtkobj ()));	

	Gtk::Window *old_window = dynamic_cast<Gtk::Window*> (old_toplevel);
	
	if (old_window)
	    old_window->remove_accel_group (*accel_group);
    }
}

void PropertyTable::map_cb ()
{
    GtkWidget *new_parent = gtk_widget_get_toplevel (GTK_WIDGET (gtkobj ()));

    if (new_parent && GTK_IS_WINDOW (new_parent))
	Gtk::wrap (GTK_WINDOW (new_parent))->add_accel_group (*accel_group);
}
