//$Id: table-prop.cc,v 1.5 2001/11/06 12:54:54 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "table-prop.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "widgets/num-entry.h"
#include "widgets/propertytable.h"

#include <gtk--/notebook.h>
#include <gtk--/box.h>
#include <gtk--/scrolledwindow.h>
#include <gtk--/table.h>
#include <gtk--/label.h>
#include <gtk--/spinbutton.h>
#include "form-editor.h"

#include "widget-prop.h"
#include "resizeable-prop.h"
#include <vector>

using namespace Guikachu::GUI::FormEditor;
using namespace Guikachu::Widgets;

namespace
{
    class TableColEditor: public Gtk::VBox
    {
	struct spinbutton_pair {
	    Gtk::Widget     *label;
	    Gtk::SpinButton *spinbutton;

	    spinbutton_pair (Gtk::Widget     *label_,
			     Gtk::SpinButton *spinbutton_):
		label (label_),
		spinbutton (spinbutton_)
		{
		};
	};
	
	Table                        *table;
	Gtk::Table                    col_list;
	std::vector<spinbutton_pair>  spinbuttons;
    public:
	TableColEditor (Table *table);
	~TableColEditor ();
    private:
	bool update_block;
	void update ();
	void col_width_cb (unsigned int column);
    };
}

TableProperties::TableProperties (Table *res)
{
    using namespace Gtk;
    using namespace SigC;

    Gtk::Notebook *notebook = new Gtk::Notebook;

    /* Page 1: General properties */    
    GUI::PropertyTable *proptable = new GUI::PropertyTable ();
    Gtk::Widget *control;
    
    /* Resource ID */
    WidgetProperties::add_general_controls (res, *proptable);

    /* Number of rows */
    control = new GUI::NumEntry (1, 160, res->num_rows);
    proptable->add (_("Number of rows:"), *manage (control));
    
    /* Separator */
    proptable->add_separator ();

    /* Position */
    WidgetProperties::add_position_controls (res, *proptable);

    /* Size */
    ResizeableProperties::add_controls (res, *proptable);

    // FIXME: Add uline accelerators to the tabs
    notebook->pages ().push_back (
	Gtk::Notebook_Helpers::TabElem (*manage (proptable),
					_("General")));

    /* Page 2: Columns */
    control = manage (new TableColEditor (res));
    notebook->pages ().push_back (
	Gtk::Notebook_Helpers::TabElem (*manage (control),
					_("Columns")));

    notebook->show_all ();
    property_editor = notebook;
}

TableProperties::~TableProperties ()
{
    delete property_editor;
}

Gtk::Widget* TableProperties::get_editor ()
{
    return property_editor;
}

TableColEditor::TableColEditor (Table *table_):
    Gtk::VBox (false, 5),
    table (table_),
    update_block (false)
{
    using Gtk::manage;

    col_list.set_row_spacings (5);
    col_list.set_col_spacings (5);
    
    Gtk::ScrolledWindow *scrolled_win = new Gtk::ScrolledWindow;
    scrolled_win->set_policy (GTK_POLICY_AUTOMATIC,
			      GTK_POLICY_ALWAYS);
    scrolled_win->add_with_viewport (col_list);
    add (*manage (scrolled_win));
    
    Gtk::Widget *num_columns = new Guikachu::GUI::NumEntry (1, 160, table->num_columns);    
    Gtk::HBox *hbox = new Gtk::HBox (false, 5);
    hbox->pack_start (*manage (
	new Gtk::Label (_("Number of columns:"), 0, 0.5)),
	false, false);
    hbox->pack_start (*manage (num_columns), false, false);

    hbox->show_all ();
    pack_start (*manage (hbox), false, false);
    set_border_width (5);

    table->changed.connect (SigC::slot (this, &TableColEditor::update));
    update ();
}

TableColEditor::~TableColEditor ()
{
    for (std::vector<spinbutton_pair>::iterator i = spinbuttons.begin ();
	 i != spinbuttons.end (); i++)
    {
	delete i->label;
	delete i->spinbutton;
    }
}

void TableColEditor::col_width_cb (unsigned int index)
{
    if (update_block)
	return;
    
    Gtk::SpinButton *spinbutton = spinbuttons[index].spinbutton;
    unsigned int new_val = spinbutton->get_value_as_int ();
    std::vector<int> columns = table->column_width;

    g_return_if_fail (index <= columns.size ());
    
    columns[index] = new_val;
    table->column_width = columns;
}

void TableColEditor::update ()
{
    if (update_block)
	return;
    
    update_block = true;
    
    const std::vector<int> &columns = table->column_width;
    unsigned int displayed_num_columns = spinbuttons.size ();
    unsigned int num_columns = table->num_columns;
    
    /* Update visible spin buttons */
    for (unsigned int i = 0; i < MIN (num_columns, displayed_num_columns); i++)
	spinbuttons[i].spinbutton->set_value (columns[i]);
    
    /* Remove spin buttons if not needed */
    if (displayed_num_columns > num_columns)
    {
	for (unsigned int i = num_columns; i < displayed_num_columns; i++)
	{
	    delete spinbuttons.back ().label;
	    delete spinbuttons.back ().spinbutton;

	    spinbuttons.pop_back ();
	}
    }
    
    /* Add new spin buttons if necessary */
    if (displayed_num_columns < num_columns)
    {
	char            *buffer;
	Gtk::SpinButton *spinbutton;
	Gtk::Widget     *label;
	Gtk::Adjustment *adj;
	
	for (unsigned int i = displayed_num_columns; i < num_columns; i++)
	{
	    buffer = g_strdup_printf (_("Column %d:"), i + 1);
	    label = new Gtk::Label (buffer);
	    label->show_all ();
	    col_list.attach (*label,
			     0, 1, i, i + 1,
			     0, 0);
	    g_free (buffer);
	    
	    adj = new Gtk::Adjustment (columns[i], 1, GUIKACHU_SCREEN_WIDTH);
	    adj->value_changed.connect (
		SigC::bind (SigC::slot (this, &TableColEditor::col_width_cb), i));
	    spinbutton = new Gtk::SpinButton (*manage (adj));
	    spinbutton->set_digits (0);
	    spinbutton->set_update_policy (GTK_UPDATE_IF_VALID);	    
	    spinbutton->show_all ();
	    col_list.attach (*spinbutton,
			     1, 2, i, i + 1,
			     GTK_FILL | GTK_EXPAND, 0);

	    spinbuttons.push_back (spinbutton_pair (label, spinbutton));
	}
    }

    update_block = false;
}

