//$Id: table-canvas.cc,v 1.4 2001/11/06 12:54:54 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "table-canvas.h"

#include "form-editor.h"

#include <gnome--/canvas-polygon.h>
#include <gnome--/canvas-line.h>

using namespace Guikachu::GUI::FormEditor;

TableCanvasItem::TableCanvasItem (Widgets::Table   *widget_,
				  FormEditor::Form *form):
    CanvasItem (widget_, form),
    widget (widget_),
    group (0)
{
    update ();
}

void TableCanvasItem::update ()
{
    if (group)
	delete group;

    group = new Gnome::CanvasGroup (*(form->get_canvas ()), 0, 0);
    
    int width = widget->get_display_width ();
    int height = widget->get_display_height ();

    /* Don't ask about the +1, I have no idea... */
    int x1 = widget->x;
    int x2 = x1 + width;
    int y1 = widget->y;
    int y2 = y1 + height;

    /* A Polygon is used instead of a Rectangle to get mouse events
     * inside the "hollow" area
     */
    static const char stipple_bits[] = {
	0x02, 0x01, };
    GdkBitmap *stipple = gdk_bitmap_create_from_data (NULL,
						      stipple_bits,
						      2, 2);
    
    Gnome::CanvasPoints frame_points;
    using Gnome::Art::Point;
    using namespace Gnome::CanvasHelpers;
    
    frame_points.push_back (Point (x1, y1));
    frame_points.push_back (Point (x2, y1));
    frame_points.push_back (Point (x2, y2));
    frame_points.push_back (Point (x1, y2));
    frame_points.push_back (Point (x1, y1));

    *(new Gnome::CanvasPolygon (*group, frame_points))
	<< outline_color (GUIKACHU_FGC)
	<< outline_stipple (stipple);

    /* Row separators */
    int row_step = height / widget->num_rows;
    int row_y = y1;
    for (int i = 0; i < widget->num_rows; i++)
    {
	Gnome::CanvasPoints line_points;
	
	line_points.push_back (Point (x1, row_y));
	line_points.push_back (Point (x2, row_y));
			       
	*(new Gnome::CanvasLine (*group, line_points))
	    << fill_color (GUIKACHU_FGC)
	    << fill_stipple (stipple);
	
	row_y += row_step;
    }
    
    /* Column separators */
    int line_x = x1;
    const std::vector<int> &columns = widget->column_width;
    int num_columns = widget->num_columns;
    for (int i = 0; i < num_columns; i++)
    {
	line_x += columns[i];
	
	Gnome::CanvasPoints line_points;
	
	line_points.push_back (Point (line_x, y1));
	line_points.push_back (Point (line_x, y2));
			       
	*(new Gnome::CanvasLine (*group, line_points))
	    << fill_color (GUIKACHU_FGC)
	    << fill_stipple (stipple);
    }

    gdk_bitmap_unref (stipple);
    
    set_canvas_item (group);
}
