<?xml version="1.0"?> <!-- -*- xml -*- -->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:exsl="http://exslt.org/common"
  extension-element-prefixes="exsl">

  <xsl:template match="/guikachu-doc">
    <xsl:message>
      <xsl:text>Creating 'index.html'</xsl:text>
    </xsl:message>
    
    <exsl:document href="index.html"
      method="html" encoding="iso-8859-1"
      indent="yes">
      <html>
	<head>
	  <title><xsl:value-of select="title/text()"/></title>
	  <link rel="stylesheet" type="text/css" href="guikachu-doc-html.css"/>
	  <link rel="toc" href="index.html#toc"/>
	</head>
	<body>

	  <xsl:apply-templates select="title"/>

	  <div id="toc">
	    <a name="toc"/>
	    <h1><xsl:text>Table of Contents</xsl:text></h1>
	    <dl>
	      <xsl:apply-templates select="section" mode="toc"/>
	    </dl>
	  </div>
	  
	  <xsl:apply-templates select="section"/>
	  
	</body>
      </html>
    </exsl:document>
  </xsl:template>
  
  <xsl:template match="section/title">
    <h1 id="section-title">
      <xsl:apply-templates/>
    </h1>
  </xsl:template>

  <xsl:template match="guikachu-doc/title">
    <h1 id="doc-title">
      <xsl:apply-templates/>
    </h1>
  </xsl:template>

  <xsl:template match="section" mode="page-contents">	
    <a name="sec-{@id}"/>
    <xsl:apply-templates select="title"/>

    <xsl:if test="para">
      <xsl:apply-templates select="para"/>
    </xsl:if>

    <xsl:if test="resource">
      <xsl:apply-templates select="resource"/>
    </xsl:if>
    
    <hr/>	  
    <p style="text-align: center">
      <a href="index.html#toc"><xsl:text>Index</xsl:text></a>
    </p>
    
  </xsl:template>
  
  <xsl:template match="section" mode="separate-file">
    <xsl:message>
      <xsl:text>Creating '</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>.html'</xsl:text>
    </xsl:message>
    
    <exsl:document href="{@id}.html"
      method="html" encoding="iso-8859-1"
      indent="yes">
      <html>
	<head>
	  <title><xsl:value-of select="title/text()"/></title>
	  <link rel="stylesheet" type="text/css" href="guikachu-doc-html.css"/>
	  <link rel="toc" href="index.html#toc"/>
	</head>
	<body>	  	  
	  <xsl:apply-templates select="." mode="page-contents"/>
	</body>
      </html>
    </exsl:document>
  </xsl:template>

  <xsl:template match="/guikachu-doc/section">
    <xsl:apply-templates select="." mode="separate-file"/>
  </xsl:template>

  <xsl:template match="/guikachu-doc/section[1]">
    <xsl:apply-templates select="." mode="page-contents"/>
  </xsl:template>

  <xsl:include href="toc.xsl"/>
  <xsl:include href="inline.xsl"/>
  <xsl:include href="property.xsl"/>
  <xsl:include href="resource.xsl"/>
  
</xsl:stylesheet>
