<?xml version="1.0"?> <!-- -*- xml -*- -->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:exsl="http://exslt.org/common"
  extension-element-prefixes="exsl">

  <xsl:template match="/guikachu-doc">   
    <xsl:message>
      <xsl:text>Creating '</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>.docbook'</xsl:text>
    </xsl:message>
    
    <exsl:document href="{@id}.docbook"
      method="xml" encoding="iso-8859-1"
      doctype-public="-//OASIS//DTD DocBook XML V4.1.2//EN">

      <article id="{@id}">
	<xsl:apply-templates/>
      </article>
      
    </exsl:document>
  </xsl:template>

  <xsl:template match="title">
    <title><xsl:apply-templates/></title>
  </xsl:template>

  <xsl:template match="section">
    <section id="{@id}">
      <xsl:apply-templates select="title"/>
      <xsl:apply-templates select="para|resource"/>
    </section>
  </xsl:template>

  <xsl:include href="inline.xsl"/>
  <xsl:include href="property.xsl"/>
  <xsl:include href="resource.xsl"/>
  
</xsl:stylesheet>
