//$Id: resizeable.h,v 1.3 2001/10/23 13:05:51 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_RESIZEABLE_H
#define GUIKACHU_FORM_EDITOR_RESIZEABLE_H

#include <sigc++/basic_signal.h>
#include <sigc++/object.h>
#include "property.h"

namespace Guikachu
{
    namespace Widgets
    {
	class Resizeable: public SigC::Object
	{
	    SigC::Signal0<void> &changed_propagate;
	    SigC::Signal0<void> manual_width_changed;
	    SigC::Signal0<void> manual_height_changed;

	protected:
	    Resizeable (SigC::Signal0<void> &changed);

	    virtual int get_auto_width () = 0;
	    virtual int get_auto_height () = 0;
	    
	public:
	    virtual ~Resizeable () {};
	    
	    virtual int get_display_width ();
	    virtual int get_display_height ();

	    Property<int>  width;
	    Property<bool> manual_width;
	    Property<int>  height;
	    Property<bool> manual_height;

	private:
	    void manual_width_cb  ();
	    void manual_height_cb ();
	};
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_RESIZEABLE_H */
