//$Id: app-res.cc,v 1.10 2001/11/06 12:54:53 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "app-res.h"
#include <gnome-xml/xmlmemory.h>

using namespace Guikachu;
using std::string;
using std::ostream;

Resources::Application::Application ():
    gui (0),
    iconname (changed, ""),
    version (changed, ""),
    vendor (changed, "")
{
}

Resources::Application::~Application ()
{
    delete gui;
}

void Resources::Application::reset ()
{
    iconname = "";
    version = "";
    vendor = "";

    changed ();
}

void Resources::Application::show_ui ()
{
    if (!gui)
	gui = new GUI::AppWindow (this);

    gui->show ();
}

bool Resources::Application::load (StorageNode &node)
{
    StorageNode curr_node;

    iconname = "";
    version =  "";
    vendor =   "";
    
    for (curr_node  = node.children ();
	 curr_node; curr_node  = curr_node.next ())
    {
	if (curr_node.name () == "iconname")
	    iconname = curr_node.get_content ();
	else if (curr_node.name () == "version")
	    version = curr_node.get_content ();
	else if (curr_node.name () == "vendor")
	    vendor = curr_node.get_content ();
	else
	    g_warning ("Error parsing `application' resource: "
		       "unexpected element `%s'", curr_node.name ().c_str ());
    }

    changed ();
    return true;
}

void Resources::Application::save (StorageNode &node) const
{
    node.add_node ("iconname", iconname);
    node.add_node ("version",  version);
    node.add_node ("vendor",   vendor);
}

void Resources::Application::save_rcp (std::ostream &ostr) const
{
    if (version != "")
	ostr << "VERSION ID 1 \"" << version << "\"" << std::endl;
    if (iconname != "")
	ostr << "APPLICATIONICONNAME ID 1 \"" << iconname << "\"" << std::endl;
    if (vendor != "")
	ostr << "APPLICATION ID 1 \"" << vendor << "\"" << std::endl;
    ostr << std::endl;
}

std::ostream& Resources::operator<< (ostream &ostr, const Application *res)
{
    res->save_rcp (ostr);
    return ostr;
}
