//$Id: string-list.h,v 1.6 2001/11/03 20:18:27 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_WIDGETS_STRING_LIST_H
#define GUIKACHU_WIDGETS_STRING_LIST_H

#include <gtk--/box.h>
#include <gtk--/list.h>
#include <gtk--/button.h>
#include <gtk--/entry.h>

#include "property.h"

#include <vector>

namespace Guikachu
{
    namespace GUI
    {
	class StringList: public Gtk::HBox
	{
	protected:
	    typedef vector<string> value_t;
	    Property<value_t> &property;

	    Gtk::List    list_widget;
	    
	private:
	    Gtk::Button *btnAdd, *btnUp, *btnDown, *btnRemove;
	    Gtk::Entry   entry;
	    Gtk::Box    *buttons;
	    
	public:
	    StringList (Property<value_t> &property);

	protected:
	    unsigned int get_selected_row ();
	    
	    bool update_block;
	    void add_button (Gtk::Widget &widget);
	    void clear_list ();
	    void add_to_list (int index, const string &label);

	    SigC::Signal1<void, unsigned int> item_added;
	    SigC::Signal1<void, unsigned int> item_removed;
	    SigC::Signal1<void, unsigned int> up;   /* Argument is the _old_ index */
	    SigC::Signal1<void, unsigned int> down; /* Argument is the _old_ index */
	    
	private:
	    virtual void update ();

	    void selection_cb ();
	    
	    void button_add_cb ();
	    void button_up_cb ();
	    void button_down_cb ();
	    void button_remove_cb ();

	    void entry_activate_cb ();
	};
    }
}

#endif /* !GUIKACHU_WIDGETS_STRING_LIST_H */
