//$Id: propertytable.h,v 1.5 2001/11/03 19:18:32 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_WIDGETS_PROPERTY_TABLE_H
#define GUIKACHU_WIDGETS_PROPERTY_TABLE_H

#include <gtk--/table.h>
#include <gtk--/text.h> // FIXME: is this include really necessary?
#include <gtk--/accelgroup.h>

namespace Guikachu
{
    namespace GUI
    {
	class PropertyTable: public Gtk::Table
	{
	    Gtk::AccelGroup *accel_group;
	    int              curr_row;

	public:
	    PropertyTable ();
	    ~PropertyTable ();
	    
	    void add_separator ();

	    void add (const string &label,
		      Gtk::Widget  &control,
		      const string &tooltip = "");

	    void add (const string &label,
		      Gtk::Text    &control,
		      const string &tooltip = "");
	protected:
	    Gtk::Widget *create_label (const string &label,
				       Gtk::Widget  &control,
				       const string &tooltip);
	    void parent_changed_cb (Gtk::Widget *old_parent);
	    void parent_changed_delegated_cb (Gtk::Widget *old_parent,
					      Gtk::Widget *widget);
	};
    }
}

#endif /* !GUIKACHU_WIDGETS_PROPERTY_TABLE_H */
