//$Id: session.cc,v 1.3 2001/11/04 21:30:21 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "session.h"

#include "config.h"

#include <glade/glade.h>
#include <gnome--/client.h>
#include <libgnome/gnome-config.h>

#include "resource-manager.h"

Guikachu::Main* Guikachu::Main::instance_ = 0;

Guikachu::Main::Main (int argc, char **argv):
    Gnome::Main (PACKAGE, VERSION, argc, argv, NULL, 0, &ctx),
    cmd_self (argv[0])
{
    if (instance_)
    {
	g_warning("Guikachu::Main::Main called twice!\n");
	return;
    }

    instance_ = this;
    
    glade_gnome_init ();
    
    Guikachu::ResourceManager::reset ();

    Gnome::Client* session_client = Gnome::Client::master_client ();
    if (session_client)
    {
	session_client->die.connect (SigC::slot(this, &Main::session_die_cb));
	session_client->save_yourself.connect (SigC::slot(this, &Main::session_save_cb));
    }
    
    const char **args = poptGetArgs (ctx);
    if (args)
	for (; *args; args++)
	    cmd_arguments.push_back (*args);
}


Guikachu::Main::~Main ()
{
    poptFreeContext (ctx);
}

const vector<string>& Guikachu::Main::get_cmd_arguments ()
{
    return cmd_arguments;
}

void Guikachu::Main::session_die_cb ()
{
    quit ();
}

int Guikachu::Main::session_save_cb (int                phase,
				     GnomeSaveStyle     save_style,
				     gint               is_shutdown,
				     GnomeInteractStyle interact_style,
				     int                is_fast)
{
    save_open_file ();
    
    return TRUE;
}

void Guikachu::Main::save_open_file ()
{
    Gnome::Client* session_client = Gnome::Client::master_client ();
    if (session_client->is_connected ())
    {
	vector<string> argv;
	argv.push_back (cmd_self);
	argv.push_back (last_filename);

	cerr << "argv[0]: " << argv[0] << endl;
	cerr << "argv[1]: " << argv[1] << endl;	
	
	session_client->set_clone_command (argv);
	session_client->set_restart_command (argv);
    }
}

void Guikachu::Main::set_filename (const string &filename)
{
    last_filename = filename;
}
