//$Id: mainwin.cc,v 1.14 2001/10/19 20:17:56 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "mainwin.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <gtk--/statusbar.h>
#include <gtk--/scrolledwindow.h>

#include <gnome--/dialog.h>
#include <gnome--/about.h>
#include <glade/glade.h>

#include <list>

#include "resource-manager.h"

#include "treeitem.h"
#include "top-treeitem.h"
#include "add-resource.h"

#include <fstream>
#include <sigc++/rettype.h>

using namespace Guikachu;

GUI::MainWin::MainWin ():
    Gnome::App ("Guikachu", "Guikachu"),
    filename (""),
    in_exit (false)
{
    using namespace SigC;
    using namespace Gnome;
    
    /* File menu */
    list <UI::Info> m_file;
    m_file.push_back (MenuItems::New    (_("_New project"), _("Create a new project"),
					 slot (this, &MainWin::new_cb)));
    m_file.push_back (MenuItems::Open   (slot (this, &MainWin::load_cb)));
    m_file.push_back (MenuItems::Save   (slot (this, &MainWin::save_cb)));
    m_file.push_back (MenuItems::SaveAs (slot (this, &MainWin::save_as_cb)));
    m_file.push_back (UI::Item          (UI::Icon (GNOME_STOCK_PIXMAP_CONVERT),
					 _("Export _RCP..."),
					 slot (this, &MainWin::export_cb),
					 _("Create an RCP file for compilation")));
    m_file.push_back (UI::Separator     ());
    m_file.push_back (MenuItems::Exit   (bind (rettype<void>(delete_event.slot()),
					       (GdkEventAny*)0)));

    /* Help menu */
    list <UI::Info> m_help;
    m_help.push_back (MenuItems::About (slot (&show_about)));

    /* Create the menu */
    list <UI::SubTree> menubar;
    menubar.push_back (Menus::File (m_file));
    menubar.push_back (Menus::Help (m_help));
    create_menus (menubar);

    /* Create status bar */
    set_statusbar (*manage (new Gtk::Statusbar ()));
    install_menu_hints ();

    /* Create the tool bar */
    list <UI::Info> toolbar;
    toolbar.push_back (UI::Item (UI::Icon (GNOME_STOCK_PIXMAP_ADD),
				 _("Add"),
				 slot (this, &MainWin::add_cb),
				 _("Add new component to current project")));
    toolbar.push_back (UI::Separator ());
    toolbar.push_back (UI::Item (UI::Icon (GNOME_STOCK_PIXMAP_NEW),
				 _("New"),
				 slot (this, &MainWin::new_cb),
				 _("New project")));
    toolbar.push_back (UI::Item (UI::Icon (GNOME_STOCK_PIXMAP_OPEN),
				 _("Open"),
				 slot (this, &MainWin::load_cb),
				 _("Open project")));
    toolbar.push_back (UI::Item (UI::Icon (GNOME_STOCK_PIXMAP_SAVE),
				 _("Save"),
				 slot (this, &MainWin::save_cb),
				 _("Save project")));

    create_toolbar (toolbar);

    // Create the tree for the resources
    Gtk::Tree *top_tree = new Gtk::Tree ();
    main_tree = new Gtk::Tree ();
    top_item = new TopTreeItem (ResourceManager::get_application ());
    top_item->show ();
    top_tree->tree ().push_back (*manage (top_item));
    top_item->set_subtree (*manage (main_tree));
    top_item->expand ();    

    // Scrollable viewport
    Gtk::ScrolledWindow *scrollwin = new Gtk::ScrolledWindow ();
    scrollwin->set_policy (GTK_POLICY_AUTOMATIC,
			   GTK_POLICY_AUTOMATIC);
    scrollwin->add_with_viewport (*manage (top_tree));
    set_contents (*manage (scrollwin));
    set_usize (300, 250);

    /* Create subtrees */
    create_tree_for_type (Resources::RESOURCE_DIALOG, _("Dialogs"));
    create_tree_for_type (Resources::RESOURCE_FORM,   _("Forms"));
    create_tree_for_type (Resources::RESOURCE_MENU,   _("Menus"));
    create_tree_for_type (Resources::RESOURCE_STRING, _("Strings"));
    create_tree_for_type (Resources::RESOURCE_BLOB, _("Blobs"));

    /* Fill with existing resources */
    set<Resources::Resource*> resources = ResourceManager::get_resources ();
    for (set<Resources::Resource*>::iterator i = resources.begin ();
	 i != resources.end (); i++)
	resource_created_cb ((*i));
    
    /* Connect to Resource Manager signals */
    ResourceManager::resource_created.connect (slot (this, &MainWin::resource_created_cb));
    ResourceManager::resource_removed.connect (slot (this, &MainWin::resource_removed_cb));

    update_title ();
}

void GUI::MainWin::resource_created_cb (Resources::Resource *resource)
{
    TreeItem *item = new GUI::TreeItem (resource);
    item->show ();

    Gtk::TreeItem *subtree_item = subtrees.find (resource->get_type ())->second;
    
    if (!subtree_item->get_subtree ())
    {
	subtree_item->set_subtree (*manage (new Gtk::Tree ()));
	subtree_item->expand ();
    }
    
    subtree_item->get_subtree ()->tree ().push_back (*manage (item));
    treeitems.insert (treeitem_map::value_type (resource, item));
}

void GUI::MainWin::resource_removed_cb (Resources::Resource *resource)
{
    treeitem_map::iterator treeitem_entry =
	treeitems.find (resource);

    if (treeitem_entry != treeitems.end ())
    {
	Gtk::TreeItem *subtree_item = subtrees.find (resource->get_type ())->second;
	Gtk::Tree_Helpers::ItemList subtree_list = subtree_item->get_subtree ()->tree ();
	
	subtree_list.remove (treeitem_entry->second);
    }
}

void GUI::MainWin::create_tree_for_type (Resources::Type type,
					 const string& category_name)
{
    Gtk::TreeItem *subtree_item = new Gtk::TreeItem (category_name);
    pair<subtree_map::iterator, bool> success;
    
    success = subtrees.insert (subtree_map::value_type (type, subtree_item));
    
    if (!success.second)
    {
	delete subtree_item;

	return;
    }

    subtree_item->show ();
    main_tree->tree ().push_back (*manage (subtree_item));
}

void GUI::MainWin::add_cb ()
{
    AddResourceWin add_win;

    add_win.run ();
}

void GUI::MainWin::update_title ()
{
    gchar *title_buf;

    if (filename != "")
	title_buf = g_strdup_printf (_("Guikachu: %s"), g_basename (filename.c_str ()));
    else
	title_buf = g_strdup_printf (_("Guikachu: %s"), "<none>");
	
    set_title (title_buf);

    g_free (title_buf);
}

void GUI::show_about ()
{
    list<string> authors;
    authors.push_back ("Gerg rdi <cactus@cactus.rulez.org>");

    Gnome::About *about = new Gnome::About ("Guikachu", VERSION,
					    "(C) 2001 Gerg rdi",
					    authors,
					    "PalmOS resource file editor");
    about->run ();  
}

void GUI::show_error (const string& message)
{
    Gnome::Dialog *dialog = Gnome::Dialogs::error (message);
    dialog->run ();  
}
