//$Id: form-res.h,v 1.16 2001/11/03 19:18:30 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_RES_H
#define GUIKACHU_FORM_RES_H

namespace Guikachu
{
    namespace Resources
    {
	class Form;
    }
}

#include "resource.h"
#include "resource-ref.h"
#include "form-editor/widget.h"
#include "form-editor/widget-ref.h"

#include <set>

namespace Guikachu
{
    namespace GUI
    {
	class FormWindow;
    }
    
    namespace Resources
    {
	class Form: public Resource
	{
	    Guikachu::GUI::FormWindow *gui;

	    set<Widgets::Widget*>  widgets;

	public:
	    Form (const string& name);
	    virtual ~Form ();
	    
	    virtual Type get_type () const { return RESOURCE_FORM; };
	    virtual void show_ui ();

	    // Widget managment
	    const set<Widgets::Widget*>& get_widgets () const { return widgets; };
	    Widgets::Widget*             get_widget (const string& id) const;
	    
	    Widgets::Widget* create_widget (Widgets::Type  type,
					    const string  &id = "");
	    void remove_widget (Widgets::Widget *widget);

	    SigC::Signal1<void, Widgets::Widget*> widget_created;
	    SigC::Signal1<void, Widgets::Widget*> widget_removed;
	    SigC::Signal0<void> widget_changed;

	    // Properties
	    Property<string>        title;
	    Properties::ResourceRef help_id;
	    Properties::ResourceRef menu_id;

	    Property<bool>          modal;
	    Property<bool>          frame;
	    Property<bool>          savebehind;
	    
	    Properties::WidgetRef   def_button;

	    Property<int>           x;
	    Property<int>           y;
	    Property<int>           width;
	    Property<int>           height;

	private:
	    // Persistance
	    virtual bool load (StorageNode &node);
	    virtual void save (StorageNode &node) const;
	    virtual void save_rcp (ostream &ostr) const;

	    Widgets::Widget* load_widget (StorageNode     &node);
	    void             save_widget (StorageNode     &node,
					  Widgets::Widget *widget) const;
	};
    };
};

#endif /* !GUIKACHU_FORM_RES_H */
