//$Id: form-res-io.cc,v 1.22 2001/11/03 19:18:30 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "form-res.h"

using namespace Guikachu;
using namespace Guikachu::Resources;

#include "form-editor/widget-util.h"

bool Form::load (StorageNode &node)
{
    // Defaults for binary tags
    frame = false;
    modal = false;
    savebehind = false;
    
    for (StorageNode curr_node  = node.children ();
	 curr_node; curr_node++)
    {
	if (curr_node.name () == "title")
	    title = curr_node.get_content ();
	else if (curr_node.name () == "help")
	    help_id = curr_node.get_prop<string> ("id");
	else if (curr_node.name () == "menu")
	    menu_id = curr_node.get_prop<string> ("id");
	else if (curr_node.name () == "modal")
	    modal = true;
	else if (curr_node.name () == "frame")
	    frame = true;
	else if (curr_node.name () == "savebehind")
	    savebehind = true;
	else if (curr_node.name () == "pos")
	{
	    x = curr_node.get_prop<int> ("x");
	    y = curr_node.get_prop<int> ("y");
	    width = curr_node.get_prop<int> ("width");
	    height = curr_node.get_prop<int> ("height");
	}
	else if (curr_node.name () == "widgets")
	{
	    def_button = curr_node.get_prop <string> ("default");
	    
	    for (StorageNode widget_node = curr_node.children ();
		 widget_node; widget_node++)
		load_widget (widget_node);
	}

	else
	    g_warning ("Error parsing `form' resource: "
		       "unexpected element `%s'",
		       curr_node.name ().c_str ());

    }

    changed ();
    
    return true;
}

Widgets::Widget* Form::load_widget (StorageNode &node)
{
    Widgets::Widget *widget = 0;
    
    const string &id = node.get_prop<string> ("id");

    if (id == "")
    {
	g_warning ("`%s': Missing ID field",
		   node.name ().c_str ());
	return NULL;
    }

    Widgets::Type type = Widgets::type_from_type_id (node.name ());

    if (type == Widgets::WIDGET_NONE)
    {
	g_warning ("Unknown widget type `%s'",
		   node.name ().c_str ());
	return NULL;
    }
	
    widget = create_widget (type, id);
    widget->load (node);
    
    return widget;
}

void Form::save (StorageNode &node) const
{
    /* Title */
    node.add_node ("title", title);

    /* Position */
    StorageNode pos = node.add_node ("pos");
    pos.set_prop ("x",      x);
    pos.set_prop ("y",      y);
    pos.set_prop ("width",  width);
    pos.set_prop ("height", height);
    
    /* Help ID */
    if (help_id != "")
	node.add_node ("help").set_prop ("id", help_id);

    /* Menu ID */
    if (menu_id != "")
	node.add_node ("menu").set_prop ("id", menu_id);

    if (modal)
	node.add_node ("modal");
    if (frame)
	node.add_node ("frame");
    if (savebehind)
	node.add_node ("savebehind");


    /* Widgets */
    if (widgets.size ())
    {
	StorageNode widgetlist_node = node.add_node ("widgets");

	if (def_button != "")
	    widgetlist_node.set_prop ("default", def_button);
	
	for (set<Widgets::Widget*>::const_iterator i = widgets.begin ();
	     i != widgets.end (); i++)
	    save_widget (widgetlist_node, *i);
    }
}

void Form::save_widget (StorageNode     &node,
			Widgets::Widget *widget) const
{
    string curr_node_name = Widgets::type_id_from_type (widget->get_type ());
    
    StorageNode widget_node = node.add_node (curr_node_name);
    widget_node.set_prop ("id", widget->id);
    widget->save (widget_node);
}

void Form::save_rcp (ostream &ostr) const
{
    ostr << "FORM ID " << id << endl;

    ostr << "AT (" << x     << " " << y      << " "
	           << width << " " << height << ")" << endl;
    ostr << "USABLE" << endl;

    if (modal)
	ostr << "MODAL ";

    if (frame)
	ostr << "FRAME ";
    else
	ostr << "NOFRAME ";

    if (savebehind)
	ostr << "SAVEBEHIND ";
    else
	ostr << "NOSAVEBEHIND ";
    ostr << endl;
    
    if (help_id != "")
	ostr << "HELPID " << help_id << endl;

    if (menu_id != "")
	ostr << "MENUID " << menu_id << endl;

    if (def_button != "")
	ostr << "DEFAULTBTNID " << def_button << endl;
    
    if (widgets.size () || (title != ""))
    {
	ostr << "BEGIN" << endl;
	ostr << "  TITLE \"" << title << "\"" << endl;
	
	for (set<Widgets::Widget*>::const_iterator i = widgets.begin ();
	     i != widgets.end (); i++)
	    ostr << *i;
	
	ostr << "END" << endl;
    }
    ostr << endl;
}
