//$Id: selector-trigger.cc,v 1.12 2001/10/26 20:46:56 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "selector-trigger.h"
#include "selector-trigger-canvas.h"

#include "form-editor.h"

#include <gnome-xml/xmlmemory.h>

using Guikachu::Widgets::SelectorTrigger;
using namespace Guikachu::GUI::FormEditor;

SelectorTrigger::SelectorTrigger (Resources::Form *owner,
				  const string& id):
    Widget (owner, id),
    Resizeable (changed),
    Textual (changed, id),
    editor (0),
    usable (changed, true),
    anchor_right (changed, false)
{
}

SelectorTrigger::~SelectorTrigger ()
{
    if (editor)
	delete editor;
}

Gtk::Widget* SelectorTrigger::create_editor ()
{
    if (!editor)
	editor = new SelectorTriggerProperties (this);
    
    return editor->get_editor ();
}

CanvasItem* SelectorTrigger::create_canvas_item (GUI::FormEditor::Form *form)
{
    return new SelectorTriggerCanvasItem (this, form);
}

bool SelectorTrigger::load (StorageNode &node)
{
    /* Non-NULL default values */
    usable = false;
    
    for (StorageNode curr_node  = node.children ();
	 curr_node; curr_node++)
    {
	if (curr_node.name () == "pos")
	{
	    x = curr_node.get_prop<int> ("x");
	    y = curr_node.get_prop<int> ("y");

	    string width_str = curr_node.get_prop<string> ("width");
	    if (width_str == "auto")
	    {
		manual_width = false;
		width = 0;
	    } else {
		manual_width = true;
		width = atoi (width_str.c_str ());
	    }
	    
	    string height_str = curr_node.get_prop<string> ("height");
	    if (height_str == "auto")
	    {
		manual_height = false;
		height = 0;
	    } else {
		manual_height = true;
		height = atoi (height_str.c_str ());
	    }
	}
	else if (curr_node.name () == "text")
	{
	    text = curr_node.get_content ();
	    font = curr_node.get_prop<int> ("font");
	}
	else if (curr_node.name () == "usable")
	    usable = true;
	else if (curr_node.name () == "anchor_right")
	    anchor_right = true;
	else
	    g_warning ("Error parsing `selector_trigger' widget: "
		       "unexpected element `%s'",
		       curr_node.name ().c_str ());
    }

    changed ();

    return true;
}

void SelectorTrigger::save (StorageNode &node) const
{
    StorageNode my_node;

    /* Position */
    my_node = node.add_node ("pos");
    my_node.set_prop ("x", x);
    my_node.set_prop ("y", y);

    /* Size */
    if (manual_width)
	my_node.set_prop ("width", width);
    else
	my_node.set_prop ("width", "auto");

    if (manual_height)
	my_node.set_prop ("height", height);
    else
	my_node.set_prop ("height", "auto");
    
    /* Usable */
    if (usable)
	node.add_node ("usable");

    /* Anchor_right */
    if (anchor_right)
	node.add_node ("anchor_right");
    
    /* Label and font */
    my_node = node.add_node ("text", text);
    my_node.set_prop ("font", font);
}

void SelectorTrigger::save_rcp (ostream &ostr) const
{
    gchar *width_str, *height_str;

    if (manual_width)
	width_str = g_strdup_printf ("%d", width ());
    else
	width_str = g_strdup ("AUTO");
    
    if (manual_height)
	height_str = g_strdup_printf ("%d", height ());
    else
	height_str = g_strdup ("AUTO");

    ostr << "  SELECTORTRIGGER \"" << text << "\" ID " << id;
    ostr << " AT (" << x << " " << y << " " << width_str << " " << height_str << ")";
    ostr << " FONT " << font;
    if (usable)
	ostr << " USABLE";
    else
	ostr << " NONUSABLE";
    if (anchor_right)
	ostr << " RIGHTANCHOR";
    else
	ostr << " LEFTANCHOR";
    
    ostr << endl;

    g_free (height_str);
    g_free (width_str);
}

int SelectorTrigger::get_auto_width ()
{
    int text_width = get_string_width (font, text);
    return 6 + text_width;
}

int SelectorTrigger::get_auto_height ()
{
    int text_height = get_font_height (font);
    return text_height + 1;
}
