//$Id: selector-trigger-canvas.cc,v 1.8 2001/08/18 14:23:02 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "selector-trigger-canvas.h"

#include "form-editor.h"

#include <gnome--/canvas-polygon.h>

using namespace Guikachu::GUI::FormEditor;

SelectorTriggerCanvasItem::SelectorTriggerCanvasItem (Widgets::SelectorTrigger *widget_,
						      FormEditor::Form         *form):
    CanvasItem (widget_, form),
    widget (widget_),
    group (0)
{
    update ();
}

void SelectorTriggerCanvasItem::update ()
{
    if (group)
	delete group;

    group = new Gnome::CanvasGroup (*(form->get_canvas ()), 0, 0);
    set_canvas_item (group);
    
    int width = widget->get_display_width ();
    int height = widget->get_display_height ();

    /* Don't ask about the +1, I have no idea... */
    int x1 = widget->x;
    int x2 = x1 + width + 1;
    int y1 = widget->y;
    int y2 = y1 + height + 1;

    /* A Polygon is used instead of a Rectangle to get mouse events
     * inside the "hollow" area
     */
    Gnome::CanvasPoints frame_points;
    using namespace Gnome::Art;
    
    frame_points.push_back (Point (x1, y1));
    frame_points.push_back (Point (x2, y1));
    frame_points.push_back (Point (x2, y2));
    frame_points.push_back (Point (x1, y2));
    frame_points.push_back (Point (x1, y1));

    /* Data for the GdkBitmap to use as an outline stipple */
    char stipple_bits[] = {
	0x01, 0x02, };

    Gnome::CanvasPolygon *frame_item = new Gnome::CanvasPolygon (*group, frame_points);    
    frame_item->set_width_units (1);

    GdkBitmap *stipple = gdk_bitmap_create_from_data (NULL,
						      stipple_bits,
						      2, 2);    
    frame_item->set_outline_stipple (stipple);
    gdk_bitmap_unref (stipple);

    if (widget->usable)
	frame_item->set_outline_color (GUIKACHU_FGC);
    else
	frame_item->set_outline_color (GUIKACHU_FGC_DISABLED);
    
    int text_x = x1 + 4;
    int text_y = y1 + height / 2;

    draw_text (*group,
	       widget->text, widget->font,
	       text_x, text_y,
	       widget->usable,
	       GTK_ANCHOR_WEST,
	       width, height);
}
