//$Id: scrollbar.cc,v 1.4 2001/09/02 20:12:57 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "scrollbar.h"
#include "scrollbar-canvas.h"

#include "form-editor.h"

#include <gnome-xml/xmlmemory.h>

using Guikachu::Widgets::ScrollBar;
using namespace Guikachu::GUI::FormEditor;

ScrollBar::ScrollBar (Resources::Form *owner,
		      const string& id):
    Widget (owner, id),
    Resizeable (changed),
    usable (changed, true),
    min_value (changed, 0),
    max_value (changed, 0),
    value (changed, 0),
    page_size (changed, 0)
{
    editor = new ScrollBarProperties (this);
}

ScrollBar::~ScrollBar ()
{
    delete editor;
}

Gtk::Widget *ScrollBar::get_editor ()
{
    return editor->get_editor ();
}

bool ScrollBar::load (xmlDocPtr doc,
		      xmlNodePtr node)
{
    xmlNodePtr curr_node;

    bool xml_pos_set = false;
    bool xml_values_set = false;
    
    gchar *xml_val;

    /* Non-NULL default values */
    usable = false;
    
#define XML_HAS_NAME(node, val) (!strcmp ((char*) node->name, val))
    
#define XML_APPLY(attr)       \
	if (xml_val)          \
	{                     \
	    attr = xml_val;   \
	    xmlFree (xml_val);\
	}

#define XML_GET_CONTENT(node, attr) \
	xml_val = (char*)xmlNodeListGetString (doc, node->xmlChildrenNode, 1); \
        XML_APPLY(attr);
    
#define XML_GET_INT_PROP(node, prop, attr)			\
	xml_val = (char*)xmlGetProp (node, (xmlChar*) prop);	\
	if (xml_val)						\
	{							\
	    attr = atoi(xml_val);				\
	    xmlFree (xml_val);					\
	}

    for (curr_node  = node->xmlChildrenNode;
	 curr_node != NULL;
	 curr_node  = curr_node->next)
    {
	if (XML_HAS_NAME (curr_node, "pos") && !xml_pos_set)
	{
	    XML_GET_INT_PROP (curr_node, "x", x);
	    XML_GET_INT_PROP (curr_node, "y", y);

	    xml_val = (char*)xmlGetProp (curr_node, (xmlChar*) "width");
	    if (!xml_val)
	    {
		manual_width = false;
	    } else {
		if (!strcasecmp (xml_val, "auto"))
		{
		    manual_width = false;
		} else {
		    manual_width = true;
		    width = atoi (xml_val);
		}
		xmlFree (xml_val);
	    }
	    
	    xml_val = (char*)xmlGetProp (curr_node, (xmlChar*) "height");
	    if (!xml_val)
	    {
		manual_height = false;
	    } else {
		if (!strcasecmp (xml_val, "auto"))
		{
		    manual_height = false;
		} else {
		    manual_height = true;
		    height = atoi (xml_val);
		}
		xmlFree (xml_val);
	    }
	    
	    xml_pos_set = true;
	}
	else if (XML_HAS_NAME (curr_node, "usable"))
	{
	    usable = true;
	}
	else if (XML_HAS_NAME (curr_node, "values") && !xml_values_set)
	{
	    XML_GET_INT_PROP (curr_node, "min",       min_value);
	    XML_GET_INT_PROP (curr_node, "max",       max_value);
	    XML_GET_INT_PROP (curr_node, "page_size", page_size);
	    XML_GET_INT_PROP (curr_node, "value",     value);
	    
	}
	else
	    g_warning ("Error parsing `scrollbar' widget: "
		       "unexpected element `%s'", curr_node->name);
    }

    changed ();

    return true;
}

void ScrollBar::save (xmlNodePtr node) const
{
    xmlNodePtr my_node;
    gchar *buffer;

    /* Position */
    my_node = xmlNewChild (node, NULL, (xmlChar*) "pos", NULL);
    buffer = g_strdup_printf ("%d", x ());
    xmlSetProp (my_node, (xmlChar*) "x", (xmlChar*) buffer);
    g_free (buffer);
    buffer = g_strdup_printf ("%d", y ());
    xmlSetProp (my_node, (xmlChar*) "y", (xmlChar*) buffer);
    g_free (buffer);

    /* Usable */
    if (usable)
	my_node = xmlNewChild (node, NULL, (xmlChar*) "usable", NULL);

    /* Values */
    my_node = xmlNewChild (node, NULL, (xmlChar*) "values", NULL);

#define XML_SET_INT_PROP(node,name,value) 			\
    buffer = g_strdup_printf ("%d", value ());			\
    xmlSetProp (node, (xmlChar*) name, (xmlChar*) buffer);	\
    g_free (buffer);

    XML_SET_INT_PROP(my_node, "min",       min_value);
    XML_SET_INT_PROP(my_node, "max",       max_value);
    XML_SET_INT_PROP(my_node, "page_size", page_size);
    XML_SET_INT_PROP(my_node, "value",     value);
}

void ScrollBar::save_rcp (ostream &ostr) const
{
    gchar *width_str, *height_str;

    if (manual_width)
	width_str = g_strdup_printf ("%d", width ());
    else
	width_str = g_strdup ("7");
    
    if (manual_height)
	height_str = g_strdup_printf ("%d", height ());
    else
	height_str = g_strdup ("AUTO");

    ostr << "  SCROLLBAR ID " << id;
    ostr << " AT (" << x << " " << y << " " << width_str << " " << height_str << ")";

    ostr << " VALUE "    << value
	 << " MIN "      << min_value
	 << " MAX "      << max_value
	 << " PAGESIZE " << page_size;

    g_free (height_str);
    g_free (width_str);
}

CanvasItem* ScrollBar::get_canvas_item (GUI::FormEditor::Form *form)
{
    return new ScrollBarCanvasItem (this, form);
}

int ScrollBar::get_display_width ()
{
    if (manual_width)
	return width;

    return 7; /* recommended width for scroll bars */
}

int ScrollBar::get_display_height ()
{
    if (manual_height)
	return height;

    return 100;
}
