//$Id: pushbutton.h,v 1.4 2001/08/18 16:22:55 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_PUSHBUTTON_H
#define GUIKACHU_FORM_EDITOR_PUSHBUTTON_H

#include <string>
#include <iostream>
#include <gnome-xml/tree.h>
#include <sigc++/basic_signal.h>
#include "widget.h"
#include "resource.h"

namespace Guikachu
{
    namespace Widgets
    {
	class PushButton;
    }
}

#include "resizeable.h"
#include "textual.h"

#include "pushbutton-prop.h"

namespace Guikachu
{
    namespace Widgets
    {
	class PushButton: public Widget,
			  public Resizeable,
			  public Textual
	{
	    GUI::FormEditor::PushButtonProperties *editor;
	    
	public:
	    PushButton (Resources::Form *owner,
			const string& id);
	    virtual ~PushButton ();
	    
	    virtual Type get_type () const { return WIDGET_PUSHBUTTON; };
	    
	    virtual GUI::FormEditor::CanvasItem *get_canvas_item (GUI::FormEditor::Form *form);
	    virtual Gtk::Widget *get_editor ();

	    virtual int get_display_width ();
	    virtual int get_display_height ();

	    Property<bool>   usable;
	    Property<int>    group;
	    
	private:
	    // Persistance
	    virtual bool load (xmlDocPtr xml_doc, xmlNodePtr node);
	    virtual void save (xmlNodePtr node) const;
	    virtual void save_rcp (ostream &ostr) const;
	};
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_PUSHBUTTON_H */
