//$Id: popup-trigger.cc,v 1.5 2001/09/02 20:12:57 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "popup-trigger.h"
#include "popup-trigger-canvas.h"

#include "form-editor.h"

#include <gnome-xml/xmlmemory.h>

using Guikachu::Widgets::PopupTrigger;
using namespace Guikachu::GUI::FormEditor;

PopupTrigger::PopupTrigger (Resources::Form *owner,
			    const string& id):
    Widget (owner, id),
    Resizeable (changed),
    Textual (changed, id),
    list_id (changed, ""),
    usable (changed, true),
    anchor_right (changed, false)
{
    editor = new PopupTriggerProperties (this);
}

PopupTrigger::~PopupTrigger ()
{
    delete editor;
}

Gtk::Widget *PopupTrigger::get_editor ()
{
    return editor->get_editor ();
}

bool PopupTrigger::load (xmlDocPtr doc,
		       xmlNodePtr node)
{
    xmlNodePtr curr_node;

    bool xml_pos_set = false;
    bool xml_text_set = false;
    bool xml_list_set = false;
    
    gchar *xml_val;

    /* Non-NULL default values */
    usable = false;
    
#define XML_HAS_NAME(node, val) (!strcmp ((char*) node->name, val))
    
#define XML_APPLY(attr)       \
	if (xml_val)          \
	{                     \
	    attr = xml_val;   \
	    xmlFree (xml_val);\
	}

#define XML_GET_CONTENT(node, attr) \
	xml_val = (char*)xmlNodeListGetString (doc, node->xmlChildrenNode, 1); \
        XML_APPLY(attr);
    
#define XML_GET_NUM_PROP(node, prop, attr)			\
	xml_val = (char*)xmlGetProp (node, (xmlChar*) prop);	\
	if (xml_val)						\
	{							\
	    attr = atoi(xml_val);				\
	    xmlFree (xml_val);					\
	}

    for (curr_node  = node->xmlChildrenNode;
	 curr_node != NULL;
	 curr_node  = curr_node->next)
    {
	if (XML_HAS_NAME (curr_node, "pos") && !xml_pos_set)
	{
	    XML_GET_NUM_PROP (curr_node, "x", x);
	    XML_GET_NUM_PROP (curr_node, "y", y);

	    xml_val = (char*)xmlGetProp (curr_node, (xmlChar*) "width");
	    if (!xml_val)
	    {
		manual_width = false;
	    } else {
		if (!strcasecmp (xml_val, "auto"))
		{
		    manual_width = false;
		} else {
		    manual_width = true;
		    width = atoi (xml_val);
		}
		xmlFree (xml_val);
	    }
	    
	    xml_val = (char*)xmlGetProp (curr_node, (xmlChar*) "height");
	    if (!xml_val)
	    {
		manual_height = false;
	    } else {
		if (!strcasecmp (xml_val, "auto"))
		{
		    manual_height = false;
		} else {
		    manual_height = true;
		    height = atoi (xml_val);
		}
		xmlFree (xml_val);
	    }
	    
	    xml_pos_set = true;
	}
	else if (XML_HAS_NAME (curr_node, "text") && !xml_text_set)
	{
	    XML_GET_CONTENT (curr_node, text);
	    XML_GET_NUM_PROP (curr_node, "font", font);
		
	    xml_text_set = true;
	}
	else if (XML_HAS_NAME (curr_node, "popuplist")  && !xml_list_set)
	{
	    xml_val = (char*)xmlGetProp (curr_node, (xmlChar*)"id");
	    XML_APPLY (list_id);
	    xml_list_set = true;
	}
	else if (XML_HAS_NAME (curr_node, "usable"))
	{
	    usable = true;
	}
	else if (XML_HAS_NAME (curr_node, "anchor_right"))
	{
	    anchor_right = true;
	}
	else
	    g_warning ("Error parsing `button' widget: "
		       "unexpected element `%s'", curr_node->name);
    }

    changed ();

    return true;
}

void PopupTrigger::save (xmlNodePtr node) const
{
    xmlNodePtr my_node;
    gchar *buffer;

    /* Position */
    my_node = xmlNewChild (node, NULL, (xmlChar*) "pos", NULL);
    buffer = g_strdup_printf ("%d", x ());
    xmlSetProp (my_node, (xmlChar*) "x", (xmlChar*) buffer);
    g_free (buffer);
    buffer = g_strdup_printf ("%d", y ());
    xmlSetProp (my_node, (xmlChar*) "y", (xmlChar*) buffer);
    g_free (buffer);

    /* Frame */
    if (manual_width)
	buffer = g_strdup_printf ("%d", width ());
    else
	buffer = g_strdup ("auto");
    xmlSetProp (my_node, (xmlChar*) "width", (xmlChar*) buffer);
    g_free (buffer);

    if (manual_height)
	buffer = g_strdup_printf ("%d", height ());
    else
	buffer = g_strdup ("auto");
    xmlSetProp (my_node, (xmlChar*) "height", (xmlChar*) buffer);
    g_free (buffer);

    if (list_id != "")
    {
	my_node = xmlNewChild (node, NULL, (xmlChar*) "popuplist", NULL);
	xmlSetProp (my_node, (xmlChar*) "id", (xmlChar*)list_id ().c_str ());
    }
    
    /* Usable */
    if (usable)
	my_node = xmlNewChild (node, NULL, (xmlChar*) "usable", NULL);
    
    /* Anchor right */
    if (anchor_right)
	my_node = xmlNewChild (node, NULL, (xmlChar*) "anchor_right", NULL);
    
    /* Label and font */
    my_node = xmlNewChild (node, NULL, (xmlChar*) "text",
			   (xmlChar*) text ().c_str ());
    buffer = g_strdup_printf ("%d", font ());
    xmlSetProp (my_node, (xmlChar*) "font", (xmlChar*) buffer);
    g_free (buffer);
}

void PopupTrigger::save_rcp (ostream &ostr) const
{
    gchar *width_str, *height_str;

    if (manual_width)
	width_str = g_strdup_printf ("%d", width ());
    else
	width_str = g_strdup ("AUTO");
    
    if (manual_height)
	height_str = g_strdup_printf ("%d", height ());
    else
	height_str = g_strdup ("AUTO");

    ostr << "  POPUPTRIGGER \"" << text << "\" ID " << id;
    ostr << " AT (" << x << " " << y << " " << width_str << " " << height_str << ")";
    ostr << " FONT " << font;
    if (usable)
	ostr << " USABLE";
    else
	ostr << " NONUSABLE";
    if (anchor_right)
	ostr << " RIGHTANCHOR";
    else
	ostr << " LEFTANCHOR";
    
    ostr << endl;

    if (list_id != "")
	ostr << "  POPUPLIST ID " << id << " " << list_id << endl;
    
    g_free (height_str);
    g_free (width_str);
}

CanvasItem* PopupTrigger::get_canvas_item (GUI::FormEditor::Form *form)
{
    return new PopupTriggerCanvasItem (this, form);
}

int PopupTrigger::get_display_width ()
{
    if (manual_width)
	return width;

    int text_width = get_string_width (font, text);
    return text_width;
}

int PopupTrigger::get_display_height ()
{
    if (manual_height)
	return height;

    int text_height = get_font_height (font);
    return text_height;
}
