//$Id: label.cc,v 1.19 2001/09/02 20:12:57 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "label.h"
#include "label-canvas.h"

#include <gnome-xml/xmlmemory.h>

using Guikachu::Widgets::Label;
using namespace Guikachu::GUI::FormEditor;

Label::Label (Resources::Form *owner,
	      const string& id):
    Widget (owner, id),
    Textual (changed, id),
    usable (changed, true)
{
    editor = new LabelProperties (this);
}

Label::~Label ()
{
    delete editor;
}

Gtk::Widget *Label::get_editor ()
{
    return editor->get_editor ();
}

bool Label::load (xmlDocPtr doc,
		  xmlNodePtr node)
{
    xmlNodePtr curr_node;

    bool xml_pos_set = false;
    bool xml_text_set = false;
    
    gchar *xml_val;

    /* Non-NULL default values */
    usable = false;
    
#define XML_HAS_NAME(node, val) (!strcmp ((char*) node->name, val))
    
#define XML_APPLY(attr)       \
	if (xml_val)          \
	{                     \
	    attr = xml_val;   \
	    xmlFree (xml_val);\
	}

#define XML_GET_CONTENT(node, attr) \
	xml_val = (char*)xmlNodeListGetString (doc, node->xmlChildrenNode, 1); \
        XML_APPLY(attr);
    
#define XML_GET_NUM_PROP(node, prop, attr)			\
	xml_val = (char*)xmlGetProp (node, (xmlChar*) prop);	\
	if (xml_val)						\
	{							\
	    attr = atoi(xml_val);				\
	    xmlFree (xml_val);					\
	}

    for (curr_node  = node->xmlChildrenNode;
	 curr_node != NULL;
	 curr_node  = curr_node->next)
    {
	if (XML_HAS_NAME (curr_node, "pos") && !xml_pos_set)
	{
	    XML_GET_NUM_PROP (curr_node, "x", x);
	    XML_GET_NUM_PROP (curr_node, "y", y);
	    
	    xml_pos_set = true;
	}
	else if (XML_HAS_NAME (curr_node, "text") && !xml_text_set)
	{
	    XML_GET_CONTENT (curr_node, text);
	    XML_GET_NUM_PROP (curr_node, "font", font);

	    xml_text_set = true;
	}
	else if (XML_HAS_NAME (curr_node, "usable"))
	{
	    usable = true;
	}
	else
	    g_warning ("Error parsing `label' widget: "
		       "unexpected element `%s'", curr_node->name);
    }

    changed ();

    return true;
}

void Label::save (xmlNodePtr node) const
{
    xmlNodePtr my_node;
    gchar *buffer;

    /* Position */
    my_node = xmlNewChild (node, NULL, (xmlChar*) "pos", NULL);
    buffer = g_strdup_printf ("%d", x ());
    xmlSetProp (my_node, (xmlChar*) "x", (xmlChar*) buffer);
    g_free (buffer);
    buffer = g_strdup_printf ("%d", y ());
    xmlSetProp (my_node, (xmlChar*) "y", (xmlChar*) buffer);
    g_free (buffer);

    /* Usable */
    if (usable)
	xmlNewChild (node, NULL, (xmlChar*) "usable", NULL);
    
    /* Text and font */
    my_node = xmlNewChild (node, NULL, (xmlChar*) "text",
			   (xmlChar*) string (text).c_str ());
    buffer = g_strdup_printf ("%d", font ());
    xmlSetProp (my_node, (xmlChar*) "font", (xmlChar*) buffer);
    g_free (buffer);
}

void Label::save_rcp (ostream &ostr) const
{
    ostr << "  LABEL \"" << text << "\"" << " ID " << id;
    ostr << " AT (" << x << " " << y << ")";
    ostr << " FONT " << font;
    if (usable)
	ostr << " USABLE";
    else
	ostr << " NONUSABLE";
    ostr << endl;
}

CanvasItem* Label::get_canvas_item (GUI::FormEditor::Form *form)
{
    return new LabelCanvasItem (this, form);
}
