//$Id: graffiti.cc,v 1.4 2001/08/18 14:23:02 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "graffiti.h"
#include "graffiti-canvas.h"

#include <gnome-xml/xmlmemory.h>

using Guikachu::Widgets::Graffiti;
using namespace Guikachu::GUI::FormEditor;

Graffiti::Graffiti (Resources::Form *owner,
		    const string& id):
    Widget (owner, id)
{
    editor = new GraffitiProperties (this);
}

Graffiti::~Graffiti ()
{
    delete editor;
}

Gtk::Widget *Graffiti::get_editor ()
{
    return editor->get_editor ();
}

bool Graffiti::load (xmlDocPtr doc,
		     xmlNodePtr node)
{
    xmlNodePtr curr_node;

    bool xml_pos_set = false;
    
    gchar *xml_val;

#define XML_HAS_NAME(node, val) (!strcmp ((char*) node->name, val))
    
#define XML_GET_NUM_PROP(node, prop, attr)			\
	xml_val = (char*)xmlGetProp (node, (xmlChar*) prop);	\
	if (xml_val)						\
	{							\
	    attr = atoi(xml_val);				\
	    xmlFree (xml_val);					\
	}

    for (curr_node  = node->xmlChildrenNode;
	 curr_node != NULL;
	 curr_node  = curr_node->next)
    {
	if (XML_HAS_NAME (curr_node, "pos") && !xml_pos_set)
	{
	    XML_GET_NUM_PROP (curr_node, "x", x);
	    XML_GET_NUM_PROP (curr_node, "y", y);
	    
	    xml_pos_set = true;
	}
	else
	    g_warning ("Error parsing `graffiti' widget: "
		       "unexpected element `%s'", curr_node->name);
    }

    changed ();

    return true;
}

void Graffiti::save (xmlNodePtr node) const
{
    xmlNodePtr my_node;
    gchar *buffer;

    /* Position */
    my_node = xmlNewChild (node, NULL, (xmlChar*) "pos", NULL);
    buffer = g_strdup_printf ("%d", x ());
    xmlSetProp (my_node, (xmlChar*) "x", (xmlChar*) buffer);
    g_free (buffer);
    buffer = g_strdup_printf ("%d", y ());
    xmlSetProp (my_node, (xmlChar*) "y", (xmlChar*) buffer);
    g_free (buffer);
}

void Graffiti::save_rcp (ostream &ostr) const
{
    ostr << "  GRAFFITISTATEINDICATOR";
    ostr << " AT (" << x << " " << y << ")";
    ostr << endl;
}

CanvasItem* Graffiti::get_canvas_item (GUI::FormEditor::Form *form)
{
    return new GraffitiCanvasItem (this, form);
}
