//$Id: canvasitem.h,v 1.2 2001/05/14 16:54:11 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_CANVASITEM_H
#define GUIKACHU_FORM_EDITOR_CANVASITEM_H

namespace Guikachu
{
    namespace GUI
    {
	namespace FormEditor
	{
	    class CanvasItem;
	}
    }
}

#include <sigc++/basic_signal.h>
#include <gnome--/canvas-item.h>
#include <gtk--/menu.h>

#include "widget.h"

namespace Guikachu
{
    namespace GUI
    {
	namespace FormEditor
	{
	    class CanvasItem: public SigC::Object
	    {
		Gnome::CanvasItem *item;
		Widgets::Widget   *widget;
		Gtk::Menu          popup_menu;
		int canvas_event_cb (GdkEvent *event);

		struct
		{
		    bool dragging;
		    bool drag_occured;

		    double last_x, last_y;
		    double offset_x, offset_y;
		} drag_context;
	    protected:
		FormEditor::Form *form;
		bool selected;
		
	    protected:
		CanvasItem (Widgets::Widget  *widget,
			    FormEditor::Form *form);
		
		void set_canvas_item (Gnome::CanvasItem *item);
		
	    public:
		virtual ~CanvasItem () {};
		void select (bool selected);

	    private:
		void remove_cb ();
		void move_cb ();

		void drag_begin  (GdkEvent *event);
		void drag_motion (GdkEvent *event);
		void drag_end    (GdkEvent *event);

		virtual void update () = 0;
	    };
	}
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_CANVASITEM_H */
