//$Id: entry.h,v 1.1 2001/04/14 18:01:40 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_WIDGETS_ENTRY_H
#define GUIKACHU_WIDGETS_ENTRY_H

#include <gtk--/entry.h>

namespace Guikachu
{
    namespace GUI
    {
	class Entry: public Gtk::Entry
	{
	    SigC::Slot0<string> get_val;
	    SigC::Slot1<void, const string&> set_val;

	public:
	    Entry (bool live_update, 
		   SigC::Slot0<string> get_slot,
		   SigC::Slot1<void, const string&> set_slot,
		   SigC::Signal0<void>& changed);
	private:
	    bool update_block;	    
	    void update ();
	    
	    void changed_cb ();
	    void activate_cb ();
	};
    }
}

#endif /* !GUIKACHU_WIDGETS_ENTRY_H */
