//$Id: entry.cc,v 1.1 2001/04/14 18:01:40 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "entry.h"

#include <sigc++/retbind.h>
#include "argumentsink.h"

using namespace Guikachu::GUI;

Entry::Entry (bool live_update,
	      SigC::Slot0<string> get_slot,
	      SigC::Slot1<void, const string&> set_slot,
	      SigC::Signal0<void>& changed_sig):
    get_val (get_slot),
    set_val (set_slot),
    update_block (false)
{
    using namespace SigC;
    
    if (live_update)
    {
	changed.connect (slot (this, &Entry::changed_cb));
    } else {
	activate.connect (slot (this, &Entry::activate_cb));
	Slot0<int> activate_slot = retbind (slot (this, &Entry::activate_cb), 0);
	focus_out_event.connect (SigC::hide <int, GdkEventFocus*> (activate_slot));
    }

    changed_sig.connect (slot (this, &Entry::update));
    update ();
}

void Entry::activate_cb ()
{
    if (!update_block)
	set_val (get_text ());
}

void Entry::changed_cb ()
{
    if (update_block)
        return;

    int saved_pos = get_position ();
    set_val (get_text ());
    set_position (saved_pos);
}

void Entry::update ()
{
    update_block = true;

    set_text (get_val ());
    
    update_block = false;
}
