//$Id: string-case.h,v 1.1 2001/02/18 14:29:22 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_STRING_CASE_H
#define GUIKACHU_STRING_CASE_H

#include <std/bastring.h>
#include <ctype.h>

struct string_case_char_traits: string_char_traits <char> {
    typedef char char_type;

    static bool eq (const char_type & c1, const char_type& c2)
	{ return (toupper (c1) == toupper (c2)); }
    static bool ne (const char_type& c1, const char_type& c2)
	{ return (toupper (c1) != toupper (c2)); }
    static bool lt (const char_type& c1, const char_type& c2)
	{ return (toupper (c1) < toupper (c2)); }
    
    static int compare (const char_type* s1, const char_type* s2, size_t n)
	{ return strncasecmp (s1, s2, n); }
};


#if 0
typedef basic_string<char, string_case_char_traits> string_case;

class Foo
{
    string str;
public:
    template <class traits, class Allocator>
    Foo (const basic_string<char, traits, Allocator> &_str)
	{
	    str = *(reinterpret_cast <const string*>(&_str));
	}
    
    template <class traits, class Allocator>
    operator basic_string<char, traits, Allocator> ()
	{
	    return *(reinterpret_cast <basic_string<char, traits,
		     Allocator>*>(&str));
	}
};

#else
template <class charT, class traits = string_char_traits <charT>,
    class Allocator = alloc>
class basic_string_ext:
    public basic_string <charT, traits, Allocator>
{
    typedef basic_string <charT, traits, Allocator> base_class;
    typedef basic_string_ext <charT, traits, Allocator> self_class;
public:
    basic_string_ext ():
	base_class ()
	{
	}
    
    template <class src_traits, class src_Allocator>
    basic_string_ext (const basic_string <charT, src_traits, src_Allocator >& _str):
	base_class (*(reinterpret_cast <const self_class*>(&_str)))
	{
	}

    basic_string_ext (charT *c_data):
	base_class (c_data)
	{
	}

    template <class dst_traits, class dst_Allocator>
    operator basic_string<charT, dst_traits, dst_Allocator> ()
	{
	    return *(reinterpret_cast <
		     basic_string <charT, dst_traits, dst_Allocator>*>
		     (this));
	}

};

typedef basic_string_ext<char, string_case_char_traits> string_case;

#endif

#endif /* !GUIKACHU_STRING_CASE_H */
