//$Id: form-win.h,v 1.12 2001/08/10 16:10:34 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKATCHU_FORM_WIN_H
#define GUIKATCHU_FORM_WIN_H

namespace Guikachu
{
    namespace GUI
    {
	class FormWindow;
    }
}

#include "form-res.h"
#include "form-editor/form.h"
#include "form-editor/widget.h"

#include <gtk--/window.h>
#include <gtk--/tree.h>
#include <gnome--/canvas.h>

#include <glade/glade-xml.h>

namespace Guikachu
{
    namespace GUI
    {
	class FormWindow: public SigC::Object
	{
	    Resources::Form            *res;
	    
	    GladeXML                   *gui;
	    Gtk::Window                *window;
	    Gtk::Window                *property_window;
	    
	    Gnome::Canvas              *canvas;
	    Gtk::TreeItem              *top_treeitem;
	    FormEditor::Form           *form;

	    Widgets::Widget            *edited_widget;

	    Gnome::CanvasItem          *canvas_overlay;
	    Widgets::Type               selected_widget_type;	    
	public:
	    FormWindow (Resources::Form *res);
	    ~FormWindow ();
	    void show ();
	    
	    Gnome::Canvas *get_canvas () const { return canvas; };
	private:
	    void show_property_editor (Widgets::Widget *widget);
	    void show_form_property_editor ();

	    int delete_event_impl (GdkEventAny *e);
	    int property_delete_event_impl (GdkEventAny *e);
	    void update ();

	    void palette_cb (Widgets::Type type);
	    int canvas_overlay_cb (GdkEvent *event);
	    void add_widget (int x, int y);	    

	    void widget_created_cb (Widgets::Widget *widget);
	    void widget_removed_cb (Widgets::Widget *widget);
	    
	    void toplevel_tree_cb ();
	    void toplevel_prev_cb ();
	    void widget_activate_tree_cb (Widgets::Widget *widget);
	    void widget_activate_prev_cb (Widgets::Widget *widget);
	};
    };
};

#endif /* !GUIKATCHU_FORM_WIN_H */
