//$Id: form-win-helpers.cc,v 1.3 2001/04/28 16:26:29 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "form-win-helpers.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <gnome--/app-helper.h>
#include <libgnomeui/gnome-stock.h>
#include <list>

using namespace Guikachu::GUI::FormWindow_Helpers;

/***********************************
 * WidgetTreeItem
 ***********************************/

WidgetTreeItem::WidgetTreeItem (Widgets::Widget *widget_):
    Gtk::TreeItem (widget_->get_id ()),
    widget (widget_)
{
    using namespace Gnome;

    set_user_data (widget);
    
    list <UI::Info> popup_menu_list;
    popup_menu_list.push_back (
	UI::Item (UI::Icon (GNOME_STOCK_PIXMAP_TRASH),
		  _("Remove"),
		  SigC::slot (this, &WidgetTreeItem::remove_cb)));
    UI::fill (popup_menu, popup_menu_list, *(popup_menu.get_accel_group ()));
    
    widget->changed.connect (slot (this, &WidgetTreeItem::update));
    button_press_event.connect (slot (this, &WidgetTreeItem::button_press_cb));
}

void WidgetTreeItem::update ()
{
    remove ();
    add_label (widget->get_id ());
}

int WidgetTreeItem::button_press_cb (GdkEventButton *e)
{
    if (e->type == GDK_BUTTON_PRESS && e->button == 1)
	activate ();
    
    if (e->button == 3)
	popup_menu.popup (e->button, e->time);
    
    return false;
}

void WidgetTreeItem::remove_cb ()
{
    widget->get_form ()->remove_widget (widget);
}


/***********************************
 * TopTreeItem
 ***********************************/

TopTreeItem::TopTreeItem (Resources::Form *res_):
    Gtk::TreeItem (res_->get_id ()),
    res (res_)
{
    set_user_data (res);
    
    res->changed.connect (slot (this, &TopTreeItem::update));
    button_press_event.connect (slot (this, &TopTreeItem::button_press_cb));
}

void TopTreeItem::update ()
{
    remove ();
    add_label (res->get_id ());
}

int TopTreeItem::button_press_cb (GdkEventButton *e)
{
    if (e->type == GDK_2BUTTON_PRESS && e->button == 1)
	activate ();
    
    return false;
}
