//$Id: form-res.cc,v 1.16 2001/07/11 19:26:46 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "form-res.h"

#include "form-editor/widget.h"
#include "form-editor/label.h"
#include "form-editor/button.h"
#include "form-editor/pushbutton.h"
#include "form-editor/graffiti.h"
#include "form-editor/selector-trigger.h"
#include "form-editor/checkbox.h"
#include "form-editor/list.h"
#include "form-editor/popup-trigger.h"

using namespace Guikachu::Resources;
using namespace Guikachu;

Form::Form (const string& id_):
    gui (0)
{
    id = id_;

    modal = false;
    frame = true;
    savebehind = false;

    title = id;
    
    x = y = 0;
    width = height = 160;
}

Form::~Form ()
{
    for (set<Widgets::Widget*>::iterator i = widgets.begin ();
	 i != widgets.end (); i++)
    {
	ResourceManager::unregister_id ((*i)->get_id ());
	delete (*i);
	widgets.erase (i);
    }
    
    delete gui;
}

void Form::show_ui ()
{
    if (!gui)
	gui = new GUI::FormWindow (this);

    gui->show ();
}

Widgets::Widget* Form::create_widget (Widgets::Type type)
{
    string prefix;

    switch (type)
    {
    case Widgets::WIDGET_LABEL:
	prefix = "label";
	break;
    case Widgets::WIDGET_BUTTON:
	prefix = "button";
	break;
    case Widgets::WIDGET_PUSHBUTTON:
	prefix = "pushbutton";
	break;
    case Widgets::WIDGET_GRAFFITI:
	prefix = "graffiti";
	break;
    case Widgets::WIDGET_SELECTOR_TRIGGER:
	prefix = "sel_trigger";
	break;
    case Widgets::WIDGET_CHECKBOX:
	prefix = "check";
	break;
    case Widgets::WIDGET_LIST:
	prefix = "list";
	break;
    case Widgets::WIDGET_POPUP_TRIGGER:
	prefix = "popup_trigger";
	break;
    default:
	g_assert_not_reached ();
	return 0;
	break;
    }
    
    return create_widget (type, ResourceManager::create_id (prefix));
}

Widgets::Widget* Form::create_widget (Widgets::Type type,
				      const string& id)
{
    if (!ResourceManager::register_id (id))
	return 0;
	
    Widgets::Widget *widget = 0;

    switch (type)
    {
    case Widgets::WIDGET_LABEL:
	widget = new Widgets::Label (this, id);
	break;
    case Widgets::WIDGET_BUTTON:
	widget = new Widgets::Button (this, id);
	break;
    case Widgets::WIDGET_PUSHBUTTON:
	widget = new Widgets::PushButton (this, id);
	break;
    case Widgets::WIDGET_GRAFFITI:
	widget = new Widgets::Graffiti (this, id);
	break;
    case Widgets::WIDGET_SELECTOR_TRIGGER:
	widget = new Widgets::SelectorTrigger (this, id);
	break;
    case Widgets::WIDGET_CHECKBOX:
	widget = new Widgets::Checkbox (this, id);
	break;
    case Widgets::WIDGET_LIST:
	widget = new Widgets::List (this, id);
	break;
    case Widgets::WIDGET_POPUP_TRIGGER:
	widget = new Widgets::PopupTrigger (this, id);
	break;
    default:
	g_assert_not_reached ();
	return 0;
	break;
    }
    
    widgets.insert (widget);
    widget->changed.connect (widget_changed.slot());
    
    widget_created (widget);

    changed ();
    
    return widget;
}

void Form::remove_widget (Widgets::Widget *widget)
{
    widget_removed.emit (widget);

    widgets.erase (widget);
    ResourceManager::unregister_id (widget->get_id ());
    
    delete widget;

    changed ();
}

Widgets::Widget* Form::get_widget (const string& id) const
{
    set<Widgets::Widget*>::const_iterator found;

    found = widgets.begin ();
    while (found != widgets.end () && (*found)->get_id () != id)
	found++;

    if (found == widgets.end ())
	return 0;
    else
	return (*found);
}
