//$Id: form-res-io.cc,v 1.14 2001/07/11 19:26:46 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "form-res.h"

using namespace Guikachu;
using namespace Guikachu::Resources;

#include <gnome-xml/xmlmemory.h>

bool Form::load (xmlDocPtr doc,
		 xmlNodePtr node)
{
    xmlNodePtr curr_node;
    bool xml_title_set      = false;
    bool xml_help_set       = false;
    bool xml_menu_set       = false;
    bool xml_pos_set        = false;
    bool xml_widgets_set    = false;
    
    gchar *xml_val = 0;

    // Defaults for binary tags
    frame = false;
    modal = false;
    savebehind = false;
    
#define XML_HAS_NAME(node,val) (!strcmp ((char*)node->name, val))
    
#define XML_APPLY(attr)       \
	if (xml_val)          \
	{                     \
	    attr = xml_val;   \
	    xmlFree (xml_val);\
	}                     \
	
#define XML_GET_CONTENT(node, attr) \
	xml_val = (char*)xmlNodeListGetString (doc, node->xmlChildrenNode, 1); \
        XML_APPLY(attr)
    
    for (curr_node  = node->xmlChildrenNode;
	 curr_node != NULL;
	 curr_node  = curr_node->next)
    {
	if (XML_HAS_NAME (curr_node, "title") && !xml_title_set)
	{
	    XML_GET_CONTENT (curr_node, title);
	    xml_title_set = true;
	}
	else if (XML_HAS_NAME (curr_node, "help")  && !xml_help_set)
	{
	    xml_val = (char*)xmlGetProp (curr_node, (xmlChar*)"id");
	    XML_APPLY (help_id);
	    xml_help_set = true;
	}
	else if (XML_HAS_NAME (curr_node, "menu")  && !xml_menu_set)
	{
	    xml_val = (char*)xmlGetProp (curr_node, (xmlChar*)"id");
	    XML_APPLY (menu_id);
	    xml_menu_set = true;
	}
	else if (XML_HAS_NAME (curr_node, "modal"))
	{
	    modal = true;
	}
	else if (XML_HAS_NAME (curr_node, "frame"))
	{
	    frame = true;
	}
	else if (XML_HAS_NAME (curr_node, "savebehind"))
	{
	    savebehind = true;
	}
	else if (XML_HAS_NAME (curr_node, "pos") && !xml_pos_set)
	{
	    xml_val = (char*)xmlGetProp (curr_node, (xmlChar*)"x");
	    if (xml_val)
	    {
		x = atoi (xml_val);
		xmlFree (xml_val);
	    }

	    xml_val = (char*)xmlGetProp (curr_node, (xmlChar*)"y");
	    if (xml_val)
	    {
		y = atoi (xml_val);
		xmlFree (xml_val);
	    }

	    xml_val = (char*)xmlGetProp (curr_node, (xmlChar*)"width");
	    if (xml_val)
	    {
		width = atoi (xml_val);
		xmlFree (xml_val);
	    }
	    
	    xml_val = (char*)xmlGetProp (curr_node, (xmlChar*)"height");
	    if (xml_val)
	    {
		height = atoi (xml_val);
		xmlFree (xml_val);
	    }
	    xml_pos_set = true;
	}
	else if (XML_HAS_NAME (curr_node, "widgets") && !xml_widgets_set)
	{
	    xml_val = (char*)xmlGetProp (curr_node, (xmlChar*)"defaultbutton");
	    if (xml_val)
	    {
		def_button = xml_val;
		xmlFree (xml_val);
	    }
	    
	    xmlNodePtr widget_node;
	    
	    for (widget_node = curr_node->xmlChildrenNode;
		 widget_node != NULL;
		 widget_node = widget_node->next)
		load_widget (doc, widget_node);
	}

	else
	    g_warning ("Error parsing `form' resource: "
		       "unexpected element `%s'", curr_node->name);

    }

    changed ();
    
    return true;
}

Widgets::Widget* Form::load_widget (xmlDocPtr doc,
				    xmlNodePtr node)
{
    Widgets::Widget *widget = 0;
    
    char *node_name = (char*)node->name;
    char *id = (char*)xmlGetProp (node, (xmlChar*)"id");

    if (!id)
    {
	g_warning ("`%s': Missing ID field", node_name);
	return NULL;
    }
	
    if (!strcmp (node_name, "label"))
	widget = create_widget (Widgets::WIDGET_LABEL, id);
    else if (!strcmp (node_name, "button"))
	widget = create_widget (Widgets::WIDGET_BUTTON, id);
    else if (!strcmp (node_name, "pushbutton"))
	widget = create_widget (Widgets::WIDGET_PUSHBUTTON, id);
    else if (!strcmp (node_name, "graffiti"))
	widget = create_widget (Widgets::WIDGET_GRAFFITI, id);
    else if (!strcmp (node_name, "selector_trigger"))
	widget = create_widget (Widgets::WIDGET_SELECTOR_TRIGGER, id);
    else if (!strcmp (node_name, "checkbox"))
	widget = create_widget (Widgets::WIDGET_CHECKBOX, id);
    else if (!strcmp (node_name, "list"))
	widget = create_widget (Widgets::WIDGET_LIST, id);
    else if (!strcmp (node_name, "popup_trigger"))
	widget = create_widget (Widgets::WIDGET_POPUP_TRIGGER, id);
    else
	g_warning ("Unknown widget type `%s'", node_name);

    if (widget)
	widget->load (doc, node);
    
    return widget;
    
}

void Form::save (xmlNodePtr node) const
{
    xmlNodePtr my_node;

    /* Title */
    my_node = xmlNewChild (node, NULL, (xmlChar*) "title",
			   (xmlChar*)title.c_str ());

    /* Position */
    gchar *buffer;
    my_node = xmlNewChild (node, NULL, (xmlChar*) "pos", NULL);
    buffer = g_strdup_printf ("%d", x);
    xmlSetProp (my_node, (xmlChar*) "x", (xmlChar*)buffer);
    g_free (buffer);
    buffer = g_strdup_printf ("%d", y);
    xmlSetProp (my_node, (xmlChar*) "y", (xmlChar*)buffer);
    g_free (buffer);
    buffer = g_strdup_printf ("%d", width);
    xmlSetProp (my_node, (xmlChar*) "width", (xmlChar*)buffer);
    g_free (buffer);
    buffer = g_strdup_printf ("%d", height);
    xmlSetProp (my_node, (xmlChar*) "height", (xmlChar*)buffer);
    g_free (buffer);
    
    
    /* Help ID */
    if (help_id != "")
    {
	my_node = xmlNewChild (node, NULL, (xmlChar*) "help", NULL);
	xmlSetProp (my_node, (xmlChar*) "id", (xmlChar*)help_id.c_str ());    
    }

    /* Menu ID */
    if (menu_id != "")
    {
	my_node = xmlNewChild (node, NULL, (xmlChar*) "menu", NULL);
	xmlSetProp (my_node, (xmlChar*) "id", (xmlChar*)menu_id.c_str ());    
    }

    if (modal)
	xmlNewChild (node, NULL, (xmlChar*) "modal", NULL);
    if (frame)
	xmlNewChild (node, NULL, (xmlChar*) "frame", NULL);
    if (savebehind)
	xmlNewChild (node, NULL, (xmlChar*) "savebehind", NULL);


    /* Widgets */
    if (widgets.size ())
    {
	xmlNodePtr widgetlist_node;
	xmlNodePtr widget_node;

	widgetlist_node = xmlNewChild (node, NULL,
				       (xmlChar*) "widgets", NULL);

	if (def_button != "")
	    xmlSetProp (widgetlist_node,
			(xmlChar*) "default", (xmlChar*) def_button.c_str ());
	
	for (set<Widgets::Widget*>::const_iterator i = widgets.begin ();
	     i != widgets.end (); i++)
	{
	    xmlChar *curr_node_name = 0;
	    
	    switch ((*i)->get_type ())
	    {
	    case Widgets::WIDGET_LABEL:
		curr_node_name = (xmlChar*) "label";
		break;
	    case Widgets::WIDGET_BUTTON:
		curr_node_name = (xmlChar*) "button";
		break;
	    case Widgets::WIDGET_PUSHBUTTON:
		curr_node_name = (xmlChar*) "pushbutton";
		break;
	    case Widgets::WIDGET_GRAFFITI:
		curr_node_name = (xmlChar*) "graffiti";
		break;
	    case Widgets::WIDGET_SELECTOR_TRIGGER:
		curr_node_name = (xmlChar*) "selector_trigger";
		break;
	    case Widgets::WIDGET_CHECKBOX:
		curr_node_name = (xmlChar*) "checkbox";
		break;
	    case Widgets::WIDGET_LIST:
		curr_node_name = (xmlChar*) "list";
		break;
	    case Widgets::WIDGET_POPUP_TRIGGER:
		curr_node_name = (xmlChar*) "popup_trigger";
		break;
	    default:
		g_assert_not_reached ();
		break;
	    }
	    
	    widget_node = xmlNewChild (widgetlist_node, NULL, curr_node_name, NULL);
	    xmlSetProp (widget_node,
			(xmlChar*)"id",
			(xmlChar*)(*i)->get_id ().c_str ());
	    (*i)->save (widget_node);
	}
    }
}

void Form::save_rcp (ostream &ostr) const
{
    ostr << "FORM ID " << id << endl;

    ostr << "AT (" << x     << " " << y      << " "
	           << width << " " << height << ")" << endl;
    ostr << "USABLE" << endl;

    if (modal)
	ostr << "MODAL ";

    if (frame)
	ostr << "FRAME ";
    else
	ostr << "NOFRAME ";

    if (savebehind)
	ostr << "SAVEBEHIND ";
    else
	ostr << "NOSAVEBEHIND ";
    ostr << endl;
    
    if (help_id != "")
	ostr << "HELPID " << help_id << endl;

    if (menu_id != "")
	ostr << "MENUID " << menu_id << endl;

    if (def_button != "")
	ostr << "DEFAULTBTNID " << def_button << endl;
    
    if (widgets.size () || (title != ""))
    {
	ostr << "BEGIN" << endl;
	ostr << "  TITLE \"" << title << "\"" << endl;
	
	for (set<Widgets::Widget*>::const_iterator i = widgets.begin ();
	     i != widgets.end (); i++)
	    ostr << *i;
	
	ostr << "END" << endl;
    }
    ostr << endl;
}
