//$Id: selector-trigger.h,v 1.1 2001/04/29 20:00:12 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_SELECTOR_TRIGGER_H
#define GUIKACHU_FORM_EDITOR_SELECTOR_TRIGGER_H

#include <string>
#include <iostream>
#include <gnome-xml/tree.h>
#include <sigc++/basic_signal.h>
#include "widget.h"
#include "resource.h"

namespace Guikachu
{
    namespace Widgets
    {
	class SelectorTrigger;
    }
}

#include "selector-trigger-prop.h"

namespace Guikachu
{
    namespace Widgets
    {
	class SelectorTrigger: public Widget
	{
	    GUI::FormEditor::SelectorTriggerProperties *editor;
	    
	public:
	    SelectorTrigger (Resources::Form *owner,
			     const string& id);
	    virtual ~SelectorTrigger ();
	    
	    virtual Type get_type () const { return WIDGET_SELECTOR_TRIGGER; };
	    
	    virtual GUI::FormEditor::CanvasItem *get_canvas_item (GUI::FormEditor::Form *form);
	    virtual Gtk::Widget *get_editor ();
	    
	    GUIKACHU_RESOURCE_PROP (text,          string);
	    GUIKACHU_RESOURCE_PROP (font,          int);

	    GUIKACHU_RESOURCE_PROP (usable,        bool);
	    GUIKACHU_RESOURCE_PROP (anchor_right,  bool);

	    GUIKACHU_RESOURCE_PROP (width,         int);
	    GUIKACHU_RESOURCE_PROP (manual_width,  bool);
	    GUIKACHU_RESOURCE_PROP (height,        int);
	    GUIKACHU_RESOURCE_PROP (manual_height, bool);
	    
	private:
	    // Persistance
	    virtual bool load (xmlDocPtr xml_doc, xmlNodePtr node);
	    virtual void save (xmlNodePtr node) const;
	    virtual void save_rcp (ostream &ostr) const;
	};
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_SELECTOR_TRIGGER_H */
