//$Id: pushbutton-prop.cc,v 1.3 2001/05/06 21:59:37 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "pushbutton-prop.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "widgets/entry.h"
#include "widgets/num-entry.h"
#include "widgets/pos-entry.h"
#include "widgets/togglebutton.h"
#include "widgets/size-entry.h"
#include "widgets/auto-toggle.h"
#include "widgets/propertytable.h"

using namespace Guikachu::GUI::FormEditor;
using namespace Guikachu::Widgets;

PushButtonProperties::PushButtonProperties (PushButton *res)
{
    using namespace Gtk;
    using namespace SigC;

    GUI::PropertyTable *proptable = new GUI::PropertyTable ();
    Gtk::Widget *control;
    
    /* Resource ID */
    control = new GUI::Entry (
	false,
	slot (res, &Widgets::PushButton::get_id),
	slot (res, &Widgets::PushButton::set_id),
	res->changed);
    proptable->add (_("Resource ID:"), *manage (control));

    /* Label */
    control = new GUI::Entry (
	true,
	slot (res, &Widgets::PushButton::get_text),
	slot (res, &Widgets::PushButton::set_text),
	res->changed);
    proptable->add (_("Text:"), *manage (control));

    /* Font */
    control = new GUI::NumEntry (
	0, 2,
	slot (res, &Widgets::PushButton::get_font),
	slot (res, &Widgets::PushButton::set_font),
	res->changed);
    proptable->add (_("Font:"), *manage (control));

    /* Usable */
    control = new GUI::ToggleButton (
	slot (res, &Widgets::PushButton::get_usable),
	slot (res, &Widgets::PushButton::set_usable),
	res->changed);
    proptable->add (_("Usable:"), *manage (control),
		    _("Non-usable widgets are not rendered by default"));

    /* Group ID */
    control = new GUI::NumEntry(
	0, 65535,
	slot (res, &Widgets::PushButton::get_group),
	slot (res, &Widgets::PushButton::set_group),
	res->changed);
    proptable->add (_("Group ID:"), *manage (control),
		    _("Only one push button can be selected "
		      "per group (select 0 for non-exclusive "
		      "buttons)"));
    
    /* Separator */
    proptable->add_separator ();

    /* X */
    control = new GUI::PosEntry (
	slot (res, &Widgets::PushButton::get_x),
	slot (res, &Widgets::PushButton::set_x),
	res->changed);
    proptable->add (_("X:"), *manage (control),
		    _("Horizontal position of the widget, relative "
		      "to the parent form"));

    /* Y */
    control = new GUI::PosEntry (
	slot (res, &Widgets::PushButton::get_y),
	slot (res, &Widgets::PushButton::set_y),
	res->changed);
    proptable->add (_("Y:"), *manage (control),
		    _("Vertical position of the widget, relative "
		      "to the parent form"));

    /* Width */
    control = new GUI::PosEntry (
	slot (res, &Widgets::PushButton::get_width),
	slot (res, &Widgets::PushButton::set_width),
	res->changed);
    control = new GUI::AutoToggle (
	*manage (control),
	slot (res, &Widgets::PushButton::get_manual_width),
	slot (res, &Widgets::PushButton::set_manual_width),
	res->changed);
    proptable->add (_("Width:"), *manage (control),
		    _("Horizontal size of the widget "
		      "(check to set manually)"));

    /* Height */
    control = new GUI::PosEntry (
	slot (res, &Widgets::PushButton::get_height),
	slot (res, &Widgets::PushButton::set_height),
	res->changed);
    control = new GUI::AutoToggle (
	*manage (control),
	slot (res, &Widgets::PushButton::get_manual_height),
	slot (res, &Widgets::PushButton::set_manual_height),
	res->changed);
    proptable->add (_("Height:"), *manage (control),
		    _("Vertical size of the widget "
		      "(check to set manually)"));
    
    proptable->show ();
    property_editor = manage (proptable);
    gtk_object_ref (GTK_OBJECT (property_editor->gtkobj ()));
}

PushButtonProperties::~PushButtonProperties ()
{
    property_editor->destroy ();
}

Gtk::Widget* PushButtonProperties::get_editor ()
{
    return property_editor;
}
