//$Id: popup-trigger-prop.cc,v 1.1 2001/07/11 19:26:46 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "popup-trigger-prop.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "widgets/entry.h"
#include "widgets/num-entry.h"
#include "widgets/pos-entry.h"
#include "widgets/togglebutton.h"
#include "widgets/size-entry.h"
#include "widgets/auto-toggle.h"
#include "widgets/propertytable.h"
#include "widgets/widget-combo.h"

using namespace Guikachu::GUI::FormEditor;
using namespace Guikachu::Widgets;

PopupTriggerProperties::PopupTriggerProperties (PopupTrigger *res)
{
    using namespace Gtk;
    using namespace SigC;

    GUI::PropertyTable *proptable = new GUI::PropertyTable ();
    Gtk::Widget *control;
    
    /* Resource ID */
    control = new GUI::Entry (
	false,
	slot (res, &Widgets::PopupTrigger::get_id),
	slot (res, &Widgets::PopupTrigger::set_id),
	res->changed);
    proptable->add (_("Resource ID:"), *manage (control));

    /* Label */
    control = new GUI::Entry (
	true,
	slot (res, &Widgets::PopupTrigger::get_text),
	slot (res, &Widgets::PopupTrigger::set_text),
	res->changed);
    proptable->add (_("Text:"), *manage (control));

    /* Font */
    control = new GUI::NumEntry (
	0, 2,
	slot (res, &Widgets::PopupTrigger::get_font),
	slot (res, &Widgets::PopupTrigger::set_font),
	res->changed);
    proptable->add (_("Font:"), *manage (control));

    /* Default button */
    control = new GUI::WidgetCombo (
	res->get_form (),
	Widgets::WIDGET_LIST,
	slot (res, &Widgets::PopupTrigger::get_list_id),
	slot (res, &Widgets::PopupTrigger::set_list_id),
	res->changed);
    proptable->add (_("List to pop up:"), *manage (control));
    
    /* Usable */
    control = new GUI::ToggleButton (
	slot (res, &Widgets::PopupTrigger::get_usable),
	slot (res, &Widgets::PopupTrigger::set_usable),
	res->changed);
    proptable->add (_("Usable:"), *manage (control),
		    _("Non-usable widgets are not rendered by default"));

    /* Anchor right */
    control = new GUI::ToggleButton (
	slot (res, &Widgets::PopupTrigger::get_anchor_right),
	slot (res, &Widgets::PopupTrigger::set_anchor_right),
	res->changed);
    proptable->add (_("Anchor right:"), *manage (control),
		    _("Keep right aligned when changing label "
		      "text at run-time"));
    
    /* Separator */
    proptable->add_separator ();

    /* X */
    control = new GUI::PosEntry (
	slot (res, &Widgets::PopupTrigger::get_x),
	slot (res, &Widgets::PopupTrigger::set_x),
	res->changed);
    proptable->add (_("X:"), *manage (control),
		    _("Horizontal position of the widget, relative "
		      "to the parent form"));

    /* Y */
    control = new GUI::PosEntry (
	slot (res, &Widgets::PopupTrigger::get_y),
	slot (res, &Widgets::PopupTrigger::set_y),
	res->changed);
    proptable->add (_("Y:"), *manage (control),
		    _("Vertical position of the widget, relative "
		      "to the parent form"));

    /* Width */
    control = new GUI::PosEntry (
	slot (res, &Widgets::PopupTrigger::get_width),
	slot (res, &Widgets::PopupTrigger::set_width),
	res->changed);
    control = new GUI::AutoToggle (
	*manage (control),
	slot (res, &Widgets::PopupTrigger::get_manual_width),
	slot (res, &Widgets::PopupTrigger::set_manual_width),
	res->changed);
    proptable->add (_("Width:"), *manage (control),
		    _("Horizontal size of the widget "
		      "(check to set manually)"));

    /* Height */
    control = new GUI::PosEntry (
	slot (res, &Widgets::PopupTrigger::get_height),
	slot (res, &Widgets::PopupTrigger::set_height),
	res->changed);
    control = new GUI::AutoToggle (
	*manage (control),
	slot (res, &Widgets::PopupTrigger::get_manual_height),
	slot (res, &Widgets::PopupTrigger::set_manual_height),
	res->changed);
    proptable->add (_("Height:"), *manage (control),
		    _("Vertical size of the widget "
		      "(check to set manually)"));
    
    proptable->show ();
    property_editor = manage (proptable);
    gtk_object_ref (GTK_OBJECT (property_editor->gtkobj ()));
}

PopupTriggerProperties::~PopupTriggerProperties ()
{
    property_editor->destroy ();
}

Gtk::Widget* PopupTriggerProperties::get_editor ()
{
    return property_editor;
}
