//$Id: popup-trigger-canvas.cc,v 1.3 2001/07/24 01:48:19 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "popup-trigger-canvas.h"

#include "form-editor.h"

#include <gnome--/canvas-polygon.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk-pixbuf/gnome-canvas-pixbuf.h>

#include "pixmaps/popup-trigger-canvas.xpm"
#include "pixmaps/popup-trigger-canvas-disabled.xpm"

using namespace Guikachu::GUI::FormEditor;

PopupTriggerCanvasItem::PopupTriggerCanvasItem (Widgets::PopupTrigger *widget_,
						      FormEditor::Form         *form):
    CanvasItem (widget_, form),
    widget (widget_),
    group (0)
{
    update ();
}

void PopupTriggerCanvasItem::update ()
{
    if (group)
	delete group;

    group = new Gnome::CanvasGroup (*(form->get_canvas ()), 0, 0);
    set_canvas_item (group);

    GdkPixbuf *pixbuf = 0;
    if (widget->get_usable ())
	pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)popup_trigger_canvas_xpm);
    else
	pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)popup_trigger_canvas_disabled_xpm);

    gnome_canvas_item_new (group->gtkobj (),
			   gnome_canvas_pixbuf_get_type (),
			   "pixbuf", pixbuf,
			   "x", (double)widget->get_x (),
			   "y", (double)widget->get_y (),
			   0);
    gdk_pixbuf_unref (pixbuf);
    
    int width = widget->get_width ();
    int height = widget->get_height ();
    
    if (!widget->get_manual_width ())
	width = get_string_width (widget->get_font (), widget->get_text ());
    if (!widget->get_manual_height ())
	height = get_font_height (widget->get_font ());

    int text_x = widget->get_x () + 15;
    int text_y = widget->get_y ();

    draw_text (*group,
	       widget->get_text (), widget->get_font (),
	       text_x, text_y,
	       widget->get_usable (),
	       GTK_ANCHOR_NW,
	       width, height);
}
