//$Id: palette.h,v 1.2 2001/08/10 16:10:35 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKATCHU_FORM_EDITOR_PALETTE_H
#define GUIKATCHU_FORM_EDITOR_PALETTE_H

namespace Guikachu
{
    namespace GUI
    {
	class Palette;
    }
}

#include "form-editor/widget.h"

#include <gtk--/window.h>
#include <gtk--/tooltips.h>
#include <gtk--/togglebutton.h>

#include <list>

namespace Guikachu
{
    namespace GUI
    {
	class Palette: public Gtk::Window
	{
	    Gtk::Tooltips            tips;
	    list<Gtk::ToggleButton*> buttons;
	public:
	    Palette ();

	    SigC::Signal1<void, Widgets::Type> palette_changed;
	    void palette_applied ();
	    
	private:
	    Gtk::ToggleButton* create_button (Widgets::Type       type,
					      const string&       tooltip,
					      const char * const *icon_xpm);

	    int  delete_event_impl (GdkEventAny *e);

	    bool inside_button_cb;
	    void widget_button_cb  (Widgets::Type type);
	};
    };
};

#endif /* !GUIKATCHU_FORM_EDITOR_PALETTE_H */
