//$Id: list.cc,v 1.3 2001/07/14 15:09:52 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "list.h"
#include "list-canvas.h"

#include <gnome-xml/xmlmemory.h>

using Guikachu::Widgets::List;
using namespace Guikachu::GUI::FormEditor;

List::List (Resources::Form *owner_,
	    const string& id_):
    font (0),
    visible_items (4),
    usable (true),
    width (1),
    manual_width (false)
{
    id = id_;
    owner = owner_;

    x = 5;
    y = 20;

    editor = new ListProperties (this);
}

List::~List ()
{
    delete editor;
}

Gtk::Widget *List::get_editor ()
{
    return editor->get_editor ();
}

bool List::load (xmlDocPtr doc,
		 xmlNodePtr node)
{
    xmlNodePtr curr_node;

    bool xml_pos_set = false;
    
    gchar *xml_val;

    /* Non-NULL default values */
    usable = false;
    
#define XML_HAS_NAME(node, val) (!strcmp ((char*) node->name, val))
    
#define XML_APPLY(attr)       \
	if (xml_val)          \
	{                     \
	    attr = xml_val;   \
	    xmlFree (xml_val);\
	}

#define XML_GET_CONTENT(node, attr) \
	xml_val = (char*)xmlNodeListGetString (doc, node->xmlChildrenNode, 1); \
        XML_APPLY(attr);
    
#define XML_GET_NUM_PROP(node, prop, attr)			\
	xml_val = (char*)xmlGetProp (node, (xmlChar*) prop);	\
	if (xml_val)						\
	{							\
	    attr = atoi(xml_val);				\
	    xmlFree (xml_val);					\
	}

    for (curr_node  = node->xmlChildrenNode;
	 curr_node != NULL;
	 curr_node  = curr_node->next)
    {
	if (XML_HAS_NAME (curr_node, "pos") && !xml_pos_set)
	{
	    XML_GET_NUM_PROP (curr_node, "x", x);
	    XML_GET_NUM_PROP (curr_node, "y", y);

	    xml_val = (char*)xmlGetProp (curr_node, (xmlChar*) "width");
	    if (!xml_val)
	    {
		manual_width = false;
	    } else {
		if (!strcasecmp (xml_val, "auto"))
		{
		    manual_width = false;
		} else {
		    manual_width = true;
		    width = atoi (xml_val);
		}
		xmlFree (xml_val);
	    }
	    
	    xml_pos_set = true;
	}
	else if (XML_HAS_NAME (curr_node, "usable"))
	{
	    usable = true;
	}
	else if (XML_HAS_NAME (curr_node, "items"))
	{
	    XML_GET_NUM_PROP (curr_node, "font", font);
	    XML_GET_NUM_PROP (curr_node, "visible", visible_items);

	    /* Iterate items */
	    xmlNodePtr item_node;
	    string     curr_item;
	    
	    for (item_node = curr_node->xmlChildrenNode;
		 item_node != NULL;
		 item_node = item_node->next)
	    {
		if (XML_HAS_NAME (item_node, "item"))
		{
		    XML_GET_CONTENT (item_node, curr_item);
		    items.push_back (curr_item);
		} else {
		    g_warning ("Error parsing `list' resource: "
			       "unexpected element `%s/%s'",
			       curr_node->name, item_node->name);
		}
	    }
	}
	else
	    g_warning ("Error parsing `list' widget: "
		       "unexpected element `%s'", curr_node->name);
    }

    changed ();
    
    return true;
}

void List::save (xmlNodePtr node) const
{
    xmlNodePtr my_node;
    gchar *buffer;

    /* Position */
    my_node = xmlNewChild (node, NULL, (xmlChar*) "pos", NULL);
    buffer = g_strdup_printf ("%d", x);
    xmlSetProp (my_node, (xmlChar*) "x", (xmlChar*) buffer);
    g_free (buffer);
    buffer = g_strdup_printf ("%d", y);
    xmlSetProp (my_node, (xmlChar*) "y", (xmlChar*) buffer);
    g_free (buffer);

    /* Size */
    if (manual_width)
	buffer = g_strdup_printf ("%d", width);
    else
	buffer = g_strdup ("auto");
    xmlSetProp (my_node, (xmlChar*) "width", (xmlChar*) buffer);
    g_free (buffer);

    /* Usable */
    if (usable)
	my_node = xmlNewChild (node, NULL, (xmlChar*) "usable", NULL);

    /* List items */
    my_node = xmlNewChild (node, NULL, (xmlChar*) "items", NULL);
    buffer = g_strdup_printf ("%d", font);
    xmlSetProp (my_node, (xmlChar*) "font", (xmlChar*) buffer);
    g_free (buffer);

    buffer = g_strdup_printf ("%d", visible_items);
    xmlSetProp (my_node, (xmlChar*) "visible", (xmlChar*) buffer);
    g_free (buffer);
    
    for (vector<string>::const_iterator i = items.begin ();
	 i != items.end (); i++)
	xmlNewChild (my_node, NULL, (xmlChar*) "item", (xmlChar*) i->c_str ());
}

void List::save_rcp (ostream &ostr) const
{
    gchar *width_str;

    if (manual_width)
	width_str = g_strdup_printf ("%d", width);
    else
	width_str = g_strdup ("AUTO");
    
    ostr << "  LIST";
    for (vector<string>::const_iterator i = items.begin ();
	 i != items.end (); i++)
	ostr << " \"" << *i << "\"";
    
    ostr << " ID " << id;
    ostr << " AT (" << x << " " << y << " " << width_str << " " << " AUTO)";
    ostr << " FONT " << font;
    if (usable)
	ostr << " USABLE";
    else
	ostr << " NONUSABLE";

    ostr << " VISIBLEITEMS " << visible_items;
    
    ostr << endl;

    g_free (width_str);
}

CanvasItem* List::get_canvas_item (GUI::FormEditor::Form *form)
{
    return new ListCanvasItem (this, form);
}
