//$Id: list-canvas.cc,v 1.6 2001/07/11 18:54:05 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "list-canvas.h"

#include "form-editor.h"

#include <gnome--/canvas.h>
#include <gnome--/canvas-polygon.h>
#include <gnome--/canvas-property.h>

using namespace Guikachu::GUI::FormEditor;

ListCanvasItem::ListCanvasItem (Widgets::List    *widget_,
				FormEditor::Form *form):
    CanvasItem (widget_, form),
    widget (widget_),
    group (0)
{
    update ();
}

void ListCanvasItem::update ()
{
    if (group)
	delete group;
    
    group = new Gnome::CanvasGroup (*(form->get_canvas ()), 0, 0);
    set_canvas_item (group);

    int font_num = widget->get_font ();    
    int height = get_font_height (font_num) * widget->get_visible_items ();
    int width = widget->get_width ();
    bool usable = widget->get_usable ();    

    /* Render text items */
    vector<string> listitems = widget->get_items ();

    // FIXME: size() is unsigned, visible_items is signed
    int visible_strings = MIN (widget->get_visible_items (),
			       listitems.size ());
    
    int line_spacing = get_font_height (font_num);
    int text_y = widget->get_y ();
    int text_x = widget->get_x () + 3;
    int max_width = 18;
    int curr_width;
    
    for (int i = 0; i < visible_strings; i++)
    {
	curr_width = get_string_width (font_num, listitems[i]) + 3;
	max_width = MAX (max_width, curr_width);
	
	draw_text (*group, listitems[i], font_num,
		   text_x, text_y, usable);
	text_y += line_spacing;
    }

    /* Render frame */
    if (!widget->get_manual_width ())
	width = max_width;

    int x1 = widget->get_x ();
    int y1 = widget->get_y ();
    int x2 = x1 + width;
    int y2 = y1 + height;
    
    using Gnome::Art::Point;
    using namespace Gnome::CanvasHelpers;
    
    Gnome::CanvasPoints frame_points;
    
    frame_points.push_back (Point (x1, y1));
    frame_points.push_back (Point (x2, y1));
    frame_points.push_back (Point (x2, y2));
    frame_points.push_back (Point (x1, y2));
    frame_points.push_back (Point (x1, y1));
    
    *(new Gnome::CanvasPolygon (*group, frame_points))
	<< width_units (1)
	<< outline_color (usable ? GUIKACHU_FGC : GUIKACHU_FGC_DISABLED);    
}
