//$Id: label-prop.cc,v 1.12 2001/07/24 01:48:19 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "label-prop.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "widgets/entry.h"
#include "widgets/num-entry.h"
#include "widgets/pos-entry.h"
#include "widgets/togglebutton.h"
#include "widgets/propertytable.h"

using namespace Guikachu::GUI::FormEditor;

LabelProperties::LabelProperties (Widgets::Label *res)
{
    using namespace SigC;
    
    GUI::PropertyTable *proptable = new GUI::PropertyTable ();
    Gtk::Widget *control;
    
    /* Resource ID */
    control = new GUI::Entry (
	false,
	slot (res, &Widgets::Label::get_id),
	slot (res, &Widgets::Label::set_id),
	res->changed);
    proptable->add (_("Resource ID:"), *manage (control));

    /* Text */
    control = new GUI::Entry (
	true,
	slot (res, &Widgets::Label::get_text),
	slot (res, &Widgets::Label::set_text),
	res->changed);
    proptable->add (_("Text:"), *manage (control));
    
    /* Font */
    control = new GUI::NumEntry (
	0, 2,
	slot (res, &Widgets::Label::get_font),
	slot (res, &Widgets::Label::set_font),
	res->changed);
    proptable->add (_("Font:"), *manage (control));
    
    /* Usable */
    control = new GUI::ToggleButton (
	slot (res, &Widgets::Label::get_usable),
	slot (res, &Widgets::Label::set_usable),
	res->changed);
    proptable->add (_("Usable:"), *manage (control),
		    _("Non-usable widgets are not rendered by default"));

    /* Separator */
    proptable->add_separator ();

    /* X */
    control = new GUI::PosEntry (
	slot (res, &Widgets::Label::get_x),
	slot (res, &Widgets::Label::set_x),
	res->changed);
    proptable->add (_("X:"), *manage (control),
		    _("Horizontal position of the widget, relative "
		      "to the parent form"));

    /* Y */
    control = new GUI::PosEntry (
	slot (res, &Widgets::Label::get_y),
	slot (res, &Widgets::Label::set_y),
	res->changed);
    proptable->add (_("Y:"), *manage (control),
		    _("Vertical position of the widget, relative "
		      "to the parent form"));
    
    proptable->show ();
    property_editor = manage (proptable);
    gtk_object_ref (GTK_OBJECT (property_editor->gtkobj ()));
}

LabelProperties::~LabelProperties ()
{
    property_editor->destroy ();
}

Gtk::Widget* LabelProperties::get_editor ()
{
    return property_editor;
}
