//$Id: label-canvas.cc,v 1.5 2001/07/24 01:48:19 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "label-canvas.h"

#include "form-editor.h"

#include <gnome--/canvas-polygon.h>

using namespace Guikachu::GUI::FormEditor;

LabelCanvasItem::LabelCanvasItem (Widgets::Label   *widget_,
				  FormEditor::Form *form):
    CanvasItem (widget_, form),
    widget (widget_),
    group (0)
{
    update ();
}

void LabelCanvasItem::update ()
{
    if (group)
	delete group;
    
    group = new Gnome::CanvasGroup (*(form->get_canvas ()), 0, 0);
    set_canvas_item (group);

    draw_text (*group,
	       widget->get_text (), widget->get_font (),
	       widget->get_x (), widget->get_y (),
	       widget->get_usable ());
}
