//$Id: graffiti-prop.cc,v 1.4 2001/04/27 20:23:43 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "graffiti-prop.h"


#include "config.h"
#include <libgnome/libgnome.h>

#include "widgets/propertytable.h"
#include "widgets/entry.h"
#include "widgets/pos-entry.h"

using namespace Guikachu::GUI::FormEditor;
using namespace Guikachu::Widgets;

GraffitiProperties::GraffitiProperties (Graffiti *res)
{
    using namespace Gtk;
    using namespace SigC;
    
    GUI::PropertyTable *proptable = new GUI::PropertyTable ();
    Gtk::Widget *control;
    
    /* Resource ID */
    control = new GUI::Entry (
	false,
	slot (res, &Widgets::Graffiti::get_id),
	slot (res, &Widgets::Graffiti::set_id),
	res->changed);
    proptable->add (_("Resource ID:"), *manage (control));

    /* Separator */
    proptable->add_separator ();

    /* X */
    control = new GUI::PosEntry (
	slot (res, &Widgets::Graffiti::get_x),
	slot (res, &Widgets::Graffiti::set_x),
	res->changed);
    proptable->add (_("X:"), *manage (control),
		    _("Horizontal position of the widget, relative "
		      "to the parent form"));
    
    /* Y */
    control = new GUI::PosEntry (
	slot (res, &Widgets::Graffiti::get_y),
	slot (res, &Widgets::Graffiti::set_y),
	res->changed);
    proptable->add (_("Y:"), *manage (control),
		    _("Vertical position of the widget, relative "
		      "to the parent form"));
    
    property_editor = manage (proptable);
    gtk_object_ref (GTK_OBJECT (property_editor->gtkobj ()));
}

GraffitiProperties::~GraffitiProperties ()
{
    property_editor->destroy ();
}

Gtk::Widget* GraffitiProperties::get_editor ()
{
    return property_editor;
}
