//$Id: graffiti-canvas.cc,v 1.4 2001/07/24 01:48:19 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "graffiti-canvas.h"

#include "form-editor.h"

#include <gnome--/canvas-polygon.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk-pixbuf/gnome-canvas-pixbuf.h>

#include "pixmaps/graffiti-canvas.xpm"

using namespace Guikachu::GUI::FormEditor;

GraffitiCanvasItem::GraffitiCanvasItem (Widgets::Graffiti *widget_,
					FormEditor::Form  *form):
    CanvasItem (widget_, form),
    widget (widget_),
    group (0)
{
    update ();
}

void GraffitiCanvasItem::update ()
{
    if (group)
	delete group;
    
    group = new Gnome::CanvasGroup (*(form->get_canvas ()), 0, 0);    
    set_canvas_item (group);
    
    GdkPixbuf *pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)graffiti_canvas_xpm);
    gnome_canvas_item_new (group->gtkobj (),
			   gnome_canvas_pixbuf_get_type (),
			   "pixbuf", pixbuf,
			   "x", (double)widget->get_x (),
			   "y", (double)widget->get_y (),
			   0);
    gdk_pixbuf_unref (pixbuf);
}
