//$Id: glyph.cc,v 1.1 2001/07/05 18:07:05 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "font.h"

#include <strstream>

using namespace Guikachu::GUI::FormEditor;

#define GLYPH_ON  '#'
#define GLYPH_OFF '-'

Glyph::Glyph (istream      &stream,
	      unsigned int &height):
    width (0),
    offset (0),
    bitmap (0)
{
    
    string curr_line;
    bool in_bitmap = true;
    bool in_header = true;

    while (in_header)
    {
	getline (stream, curr_line);

	if (curr_line[0] == GLYPH_ON ||
	    curr_line[0] == GLYPH_OFF)
	{
	    in_header = false;
	    continue;
	}

	strstream curr_line_stream;
	string    param_name;
	int       param_val;
	
	curr_line_stream << curr_line;
	curr_line_stream >> param_name;
	curr_line_stream >> param_val;

	if (param_name == "OFFSET")
	    offset = param_val;
    }

    unsigned int row = 0;
    
    while (in_bitmap)
    {
	if (curr_line == "")
	{
	    in_bitmap = false;
	    continue;
	}

	if (!width)
	    width = curr_line.length ();

	bitmap = (bool**) realloc (bitmap, (row + 1) * sizeof (bool*));
	bitmap[row] = new bool[width];

	for (unsigned int i = 0; i < width; i++)
	    bitmap[row][i] = (curr_line[i] == GLYPH_ON) ? true : false;
	
	getline (stream, curr_line);
	row++;
    }

    if (!height)
	height = row;
}

