//$Id: form.h,v 1.7 2001/08/10 16:10:35 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_FORM_H
#define GUIKACHU_FORM_EDITOR_FORM_H

namespace Guikachu
{
    namespace GUI
    {
	namespace FormEditor
	{
	    class Form;
	}
    }
}

#include "form-res.h"
#include "form-win.h"
#include "form-prop.h"

#include <string>
#include <gnome--/canvas-group.h>
#include <sigc++/object.h>

namespace Guikachu
{
    namespace GUI
    {
	namespace FormEditor
	{
	    class Form: public SigC::Object
	    {
		Resources::Form *res;
		GUI::FormWindow *win;
		FormProperties   editor;
		
		Gnome::CanvasGroup *group;
		Gnome::CanvasGroup *frame_group;
		Gnome::CanvasGroup *title_group;
		Gnome::CanvasGroup *widget_group;
	    public:
		Form (Resources::Form *res,
		      GUI::FormWindow *win);
		~Form ();
		Gtk::Widget *get_editor ();
		
		Gnome::CanvasGroup *get_canvas () const;
		SigC::Signal0<void> show_editor;
	    private:
		void update ();
		
		/* Drawing methods */
		void draw_frame ();
		void draw_title ();
		
		void draw_frame_modal ();
		void draw_frame_nonmodal ();
		void draw_title_modal ();
		void draw_title_nonmodal ();
		
		/* Callbacks */
		int canvas_event_cb (GdkEvent *e);
	    };
	}
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_FORM_H */
