//$Id: font.h,v 1.2 2001/07/05 22:25:14 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_FONT_H
#define GUIKACHU_FORM_EDITOR_FONT_H

#include <string>
#include <iostream>
#include <hash_map>

#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk--/color.h>

namespace Guikachu
{
    namespace GUI
    {
	namespace FormEditor
	{
	    struct Glyph
	    {
		unsigned int   width;
		int            offset;
		bool         **bitmap;
	    public:
		Glyph (istream &stream, unsigned int &height);
	    };
	    
	    class Font
	    {
		hash_map <char, Glyph> glyphs;
		unsigned int          height;
		
	    public:
		Font (const string &filename);
		Font ();

		void parse (const string& filename);
		void parse (istream &stream);

		GdkPixbuf* render (const string    &text,
				   const Gdk_Color &color) const;
		unsigned int string_width (const string& text) const;
	    };
	}
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_FONT_H */
