//$Id: button-canvas.cc,v 1.5 2001/07/24 01:48:19 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "button-canvas.h"

#include "form-editor.h"

#include <gnome--/canvas-polygon.h>

using namespace Guikachu::GUI::FormEditor;

ButtonCanvasItem::ButtonCanvasItem (Widgets::Button  *widget_,
				    FormEditor::Form *form):
    CanvasItem (widget_, form),
    widget (widget_),
    group (0)
{
    update ();
}

void ButtonCanvasItem::update ()
{
    if (group)
	delete group;

    group = new Gnome::CanvasGroup (*(form->get_canvas ()), 0, 0);
    set_canvas_item (group);
    
    int width = widget->get_width ();
    int height = widget->get_height ();
    int frame_width = 0;
    
    int text_height, text_width;

    text_width = get_string_width (widget->get_font (), widget->get_text ());
    text_height = get_font_height (widget->get_font ());
    
    if (!widget->get_manual_width ())
	width = 2 + text_width + 2;
    if (!widget->get_manual_height ())
	height = text_height + 3;

    switch (widget->get_frame ())
    {
    case Widgets::BUTTON_FRAME_NONE:
	frame_width = 0;
	break;
    case Widgets::BUTTON_FRAME_SIMPLE:
	frame_width = 1;
	break;
    case Widgets::BUTTON_FRAME_BOLD:
	frame_width = 2;
	break;
    }
    
    int x1 = widget->get_x ();
    int x2 = x1 + width;
    int y1 = widget->get_y ();
    int y2 = y1 + height;

    if (widget->get_frame () != Widgets::BUTTON_FRAME_NONE)
    {
	Gnome::CanvasPoints frame_points;
	using namespace Gnome::Art;
	
	frame_points.push_back (Point (x1,     y1 + 2));
	frame_points.push_back (Point (x1 + 2, y1    ));

	frame_points.push_back (Point (x2 - 2, y1    ));
	frame_points.push_back (Point (x2,     y1 + 2));
	
	frame_points.push_back (Point (x2,     y2 - 2));
	frame_points.push_back (Point (x2 - 2, y2));
	
	frame_points.push_back (Point (x1 + 2, y2));
	frame_points.push_back (Point (x1,     y2 - 2));

	frame_points.push_back (Point (x1,     y1 + 2));
	
	Gnome::CanvasPolygon *button_frame = new Gnome::CanvasPolygon (*group, frame_points);
	button_frame->set_width_units (frame_width);

	if (widget->get_usable ())
	    button_frame->set_outline_color (GUIKACHU_FGC);
	else
	    button_frame->set_outline_color (GUIKACHU_FGC_DISABLED);
    }
	
    int text_x = x1 + width / 2;
    int text_y = y1 + height / 2;
    
    draw_text (*group,
	       widget->get_text (), widget->get_font (),
	       text_x, text_y,
	       widget->get_usable (),
	       GTK_ANCHOR_CENTER,
	       width, height);
}
