//$Id: string-list.cc,v 1.1 2001/05/11 16:37:09 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "string-list.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <gtk--/scrolledwindow.h>
#include <gtk--/buttonbox.h>
#include <gnome--/stock.h>

using namespace Guikachu::GUI;

StringList::StringList (get_slot_t get_slot,
			set_slot_t set_slot,
			changed_t& changed_sig):
    get_val (get_slot),
    set_val (set_slot),
    update_block (false)
{
    using namespace SigC;

    /* The List holding the strings */
    string_list = new Gtk::List;
    string_list->selection_changed.connect (slot (this, &StringList::selection_cb));

    Gtk::ScrolledWindow *scrollwin = new Gtk::ScrolledWindow;
    scrollwin->add_with_viewport (*manage (string_list));
    scrollwin->set_policy (GTK_POLICY_AUTOMATIC,
			   GTK_POLICY_AUTOMATIC);
    
    scrollwin->show_all ();
    add (*manage (scrollwin));

    /* The modifier buttons */
    btnAdd  = Gtk::wrap (GTK_BUTTON (
	gnome_pixmap_button (
	    GTK_WIDGET (manage(new Gnome::Stock::Pixmap (GNOME_STOCK_PIXMAP_ADD))->gtkobj ()),
	    _("Add..."))));
    btnRemove  = Gtk::wrap (GTK_BUTTON (
	gnome_pixmap_button (
	    GTK_WIDGET (manage(new Gnome::Stock::Pixmap (GNOME_STOCK_PIXMAP_REMOVE))->gtkobj ()),
	    _("Remove"))));
    btnUp   = new Gnome::Stock::Button (GNOME_STOCK_BUTTON_UP);
    btnDown = new Gnome::Stock::Button (GNOME_STOCK_BUTTON_DOWN);

    Gtk::VButtonBox *buttons = new Gtk::VButtonBox;
    buttons->add (*manage (btnUp));
    buttons->add (*manage (btnDown));
    buttons->add (*manage (btnRemove));
    buttons->add (*manage (btnAdd));
    buttons->show_all ();
    add (*manage (buttons));
    
    changed_sig.connect (slot (this, &StringList::update));
    update ();
    selection_cb ();
}

void StringList::update ()
{
    update_block = true;

    update_block = false;
}

void StringList::selection_cb ()
{
    Gtk::List::SelectionList sel_list = string_list->selection ();
	
    if (!sel_list.size ())
    {
	
	btnRemove->set_sensitive (false);
	btnUp->set_sensitive (false);
	btnDown->set_sensitive (false);
	
    } else {
	
	g_return_if_fail (sel_list.size() == 1);

	unsigned int index = GPOINTER_TO_UINT ((*(sel_list.begin()))->get_user_data ());
    
	btnRemove->set_sensitive (true);
	btnUp->set_sensitive ((index > 0));
	btnDown->set_sensitive ((index < (string_list->items ().size () - 1)));
    }
}
