//$Id: propertytable.cc,v 1.4 2001/05/09 16:07:05 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "propertytable.h"

#include <gtk--/separator.h>
#include <gtk--/label.h>
#include <gtk--/eventbox.h>
#include <gtk--/tooltips.h>

using namespace Guikachu::GUI;

PropertyTable::PropertyTable ():
    curr_row (0)
{
    set_border_width (5);
    set_row_spacings (5);
    set_col_spacings (5);
}

void PropertyTable::add (const string& label,
			 Gtk::Widget& control,
			 const string& tooltip = "")
{
    Gtk::Widget  *description_widget;
    Gtk::Label   *label_widget = new Gtk::Label (label, 1, 0.5);
    gint          accel_key;

    accel_key = label_widget->parse_uline (label);
    /*
    gtk_widget_add_accelerator(entry, "grab_focus", accel_group, accel_key,
			       GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);
    */
    /*
    control->add_accelerator ("grab_focus",
			      accel_key,
			      GDK_MOD1_MASK, GTK_ACCEL_VISIBLE
    */
			      
    if (tooltip != "")
    {
	Gtk::EventBox *e_box = new Gtk::EventBox;
	e_box->add (*manage (label_widget));
	
	Gtk::Tooltips *tips = new Gtk::Tooltips;
	tips->set_tip (*e_box, tooltip);
	manage (tips);

	description_widget = e_box;
    } else {
	description_widget = label_widget;
    }
    
    description_widget->show_all ();
    control.show ();
    
    attach (*manage (description_widget),
	    0, 1,
	    curr_row, curr_row + 1,
	    GTK_FILL,
	    GTK_FILL);
    attach (control,
	    1, 2,
	    curr_row, curr_row + 1,
	    GTK_FILL | GTK_EXPAND,
	    GTK_FILL);

    curr_row++;
}

void PropertyTable::add_separator ()
{
    Gtk::HSeparator *separator = new Gtk::HSeparator ();

    separator->show ();

    attach (*manage (separator),
	    0, 2,
	    curr_row, curr_row + 1,
	    GTK_FILL, GTK_FILL);

    curr_row++;
}
