//$Id: main.cc,v 1.6 2001/07/08 17:03:10 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "config.h"

#include <gnome--/main.h>
#include <glade/glade.h>
#include <fcntl.h>

#include "mainwin.h"
#include "resource-manager.h"

#include <string>

namespace Guikachu
{
    enum FileType
    {
	FILETYPE_REGULAR,
	FILETYPE_GLADE,
	FILETYPE_FONT
    };

    struct FileEntry
    {
	const char *filename;
	FileType type;
    };
}

using namespace Guikachu;

static bool check_file (FileEntry& file)
{
    bool success = true;
    string filename = file.filename;

    /* For _REGULAR and _FONT */
    int fd = -1;

    /* For _GLADE */
    GladeXML *gui = 0;
    
    switch (file.type)
    {
    case FILETYPE_REGULAR:
	fd = open (filename.c_str (), 0);
	if (fd == -1)
	    success = false;
	else
	    close (fd);
	break;
	
    case FILETYPE_GLADE:
	filename = string (GLADEDIR) + "/" + filename;
	gui = glade_xml_new (filename.c_str (), 0);
	if (!gui)
	    success = false;
	else
	    gtk_object_unref (GTK_OBJECT (gui));
	break;
	
    case FILETYPE_FONT:
	filename = string (FONTDIR) + "/" + filename;
	fd = open (filename.c_str (), 0);
	if (fd == -1)
	    success = false;
	else
	    close (fd);
	break;
    }

    return success;
}

static bool check_files ()
{
    bool success = true;
    
    FileEntry files[] = {
	{"guikachu.glade", FILETYPE_GLADE},
	{"stdfont.txt",    FILETYPE_FONT},
	{"boldfont.txt",   FILETYPE_FONT},
	{"bigfont.txt",    FILETYPE_FONT}
    };

    for (unsigned int i = 0;
	 i < (sizeof (files) / sizeof (FileEntry*) - 1);
	 i++)
    {
	if (!check_file (files[i]))
	{
	    success = false;
	    gchar *buffer = g_strdup_printf (
		_("Opening file `%s' (required by Guikachu) failed.\n"
		  "Check your Guikachu installation"),
		g_basename (files[i].filename));
	    
	    GUI::show_error (buffer);
	    g_free (buffer);
	}
    }

    return success;
}

int main (int argc, char **argv)
{
#ifdef ENABLE_NLS
    bindtextdomain (PACKAGE, GNOMELOCALEDIR);
    textdomain (PACKAGE);
#endif

    poptContext ctx;
    Gnome::Main m (PACKAGE, VERSION, argc, argv, NULL, 0, &ctx);
    glade_gnome_init ();

    if (!check_files ())
	return -1;

    ResourceManager::reset ();
    GUI::MainWin w;

    const char **args = poptGetArgs (ctx);
    string filename;
    if (args)
    {
	for (; *args; args++)
	    filename = *args;
	
	ResourceManager::load (filename);
	w.set_filename (filename);
    }
    poptFreeContext (ctx);
    
    w.show_all ();
    m.run ();
}
