//$Id: app-win.cc,v 1.4 2001/05/02 14:01:34 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "app-win.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "widgets/propertytable.h"
#include "widgets/entry.h"

using namespace Guikachu;

GUI::AppWindow::AppWindow (Resources::Application *res_):
    res (res_)
{
    using namespace SigC;
    
    window = new Gtk::Window (GTK_WINDOW_DIALOG);
    window->set_policy (false, true, false);
    window->delete_event.connect (SigC::slot (this, &AppWindow::delete_event_impl));

    GUI::PropertyTable *proptable = new GUI::PropertyTable ();
    Gtk::Entry *control;
    
    /* Icon caption */
    control = new GUI::Entry (
	false,
	slot (res, &Resources::Application::get_iconname),
	slot (res, &Resources::Application::set_iconname),
	res->changed);
    proptable->add (_("Icon caption:"), *manage (control));

    /* Version */
    control = new GUI::Entry (
	false,
	slot (res, &Resources::Application::get_version),
	slot (res, &Resources::Application::set_version),
	res->changed);
    proptable->add (_("Version:"), *manage (control));

    /* Vendor ID */
    control = new GUI::Entry (
	false,
	slot (res, &Resources::Application::get_vendor),
	slot (res, &Resources::Application::set_vendor),
	res->changed);
    control->set_max_length (4);
    proptable->add (_("Vendor ID:"), *manage (control));

    proptable->show_all ();
    window->add (*manage (proptable));

    res->changed.connect (slot (this, &AppWindow::update));
    update ();
}

GUI::AppWindow::~AppWindow ()
{
    delete window;
}

int GUI::AppWindow::delete_event_impl (GdkEventAny *e)
{
    window->hide ();
    return true;
}

void GUI::AppWindow::show ()
{
    window->show_all ();
    window->get_window ().raise ();
}

void GUI::AppWindow::update ()
{
    gchar *title_buf = g_strdup_printf (_("Application: %s"), res->get_iconname ().c_str ());
    window->set_title (title_buf);
    g_free (title_buf);
}
