//$Id: string-list.h,v 1.1 2001/05/11 16:37:09 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_WIDGETS_STRING_LIST_H
#define GUIKACHU_WIDGETS_STRING_LIST_H

#include <gtk--/box.h>
#include <gtk--/list.h>
#include <gtk--/button.h>

#include <vector>

namespace Guikachu
{
    namespace GUI
    {
	class StringList: public Gtk::HBox
	{
	    typedef SigC::Slot0<vector<string> > get_slot_t;
	    typedef SigC::Slot1<void, const vector<string>&> set_slot_t;
	    typedef SigC::Signal0<void> changed_t;
	    
	    get_slot_t get_val;
	    set_slot_t set_val;

	    Gtk::List   *string_list;
	    Gtk::Button *btnAdd, *btnUp, *btnDown, *btnRemove;
	    
	public:
	    StringList (get_slot_t get_slot,
			set_slot_t set_slot,
			changed_t& changed);
	private:
	    bool update_block;
	    void update ();

	    void selection_cb ();
	    
	    void button_add_cb ();
	    void button_up_cb ();
	    void button_down_cb ();
	    void button_remove_cb ();
	};
    }
}

#endif /* !GUIKACHU_WIDGETS_STRING_LIST_H */
