//$Id: string-res.cc,v 1.5 2001/05/17 22:08:54 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "string-res.h"

#include <gnome-xml/xmlmemory.h>

using namespace Guikachu;

Resources::String::String (const string& id_):
    gui (0)
{
    id = id_;
}

Resources::String::~String ()
{
    delete gui;
}

void Resources::String::show_ui ()
{
    if (!gui)
	gui = new GUI::StringWindow (this);

    gui->show ();
}

bool Resources::String::load (xmlDocPtr doc,
			      xmlNodePtr node)
{
    xmlNodePtr curr_node;
    gchar *xml_text = 0;
    
    for (curr_node  = node->xmlChildrenNode;
	 curr_node != NULL;
	 curr_node  = curr_node->next)
    {
	if (!strcmp ((char*)curr_node->name, "text") && !xml_text)
	{
	    xml_text = (gchar*)xmlNodeListGetString (doc, curr_node->xmlChildrenNode, 1);
	}
	else
	    g_warning ("Error parsing `string' resource: "
		       "unexpected element `%s'", curr_node->name);
    }

    if (!xml_text)
	return false;
    
    text = xml_text;
    xmlFree (xml_text);

    changed ();
    
    return true;
}

void Resources::String::save (xmlNodePtr node) const
{
    xmlNewChild (node, NULL, (xmlChar*)"text", (xmlChar*)text.c_str ());
}

void Resources::String::save_rcp (ostream &ostr) const
{
    ostr << "STRING ID " << id << " \"" << text << "\"" << endl
	 << endl;
}
